/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ Œ蒷v[                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_mpf_h__
#define __HOS_V4__knl_mpf_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_MPFID	TMIN_MPFID			/* Œ蒷v[ID̍ŏl */
#define KERNEL_TMAX_MPFID	(KERNEL_TMIN_MPFID + kernel_mpfcb_cnt - 1)
												/* Œ蒷v[ID̍ől */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* Œ蒷v[ */
typedef struct t_cmpf
{
	ATR  mpfatr;		/* Œ蒷v[ */
	UINT blkcnt;		/* lł郁ubN() */
	UINT blksz;			/* ubÑTCY(oCg) */
	VP   mpf;			/* Œ蒷v[̈̐擪Ԓn */
} T_CMPF;

/* Œ蒷v[ */
typedef struct t_rmpf
{
	ID   wtskid;		/* Œ蒷v[̑҂s̐擪̃^XNIDԍ */
	UINT fblkcnt;		/* Œ蒷v[̋󂫃ubN() */
} T_RMPF;


/* Œ蒷v[Rg[ubN(ROM) */
typedef struct t_kernel_mpfcb_rom
{
	ATR  mpfatr;		/* Œ蒷v[ */
	UINT blkcnt;		/* lł郁ubN() */
	UINT blksz;			/* ubÑTCY(oCg) */
	VP   mpf;			/* Œ蒷v[̈̐擪Ԓn */
} T_KERNEL_MPFCB_ROM;


/* Œ蒷v[Rg[ubN(RAM) */
typedef struct t_kernel_mpfcb_ram
{
	T_MKNL_QUE que;		/* Œ蒷v[҂^XNL[ */
	VP         free;	/* 󂫃ubNւ̃|C^ */
	const T_KERNEL_MPFCB_ROM *mpfcb_rom;	/* Œ蒷v[Rg[ubNROMւ̃|C^ */
} T_KERNEL_MPFCB_RAM;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* Œ蒷v[Ǘ */
extern       T_KERNEL_MPFCB_RAM *kernel_mpfcb_ram_tbl[];	/* Œ蒷v[Rg[ubNe[u(RAM) */
extern const INT kernel_mpfcb_cnt;							/* Œ蒷v[Rg[ubN */

/* Œ蒷v[Rg[ubNϊ}N */
#define KERNEL_MPFID_TO_MPFCB_RAM(mpfid)	(kernel_mpfcb_ram_tbl[(mpfid) - KERNEL_TMIN_MPFID])
															/* Œ蒷v[IDMPFCB RAMAhX擾 */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* Œ蒷v[ */
void    kernel_ini_mpf(void);								/* Œ蒷v[̏ */
ER      cre_mpf(ID mpfid, const T_CMPF *pk_cmpf);			/* Œ蒷v[̐ */
ER_ID   acre_mpf(const T_CMPF *pk_cmpf);					/* Œ蒷v[̐(IDԍt) */
ER      kernel_cre_mpf(ID mpfid, const T_CMPF *pk_cmpf);	/* Œ蒷v[̐(J[l֐) */
ER      del_mpf(ID mpfid);									/* Œ蒷v[̍폜 */
ER      get_mpf(ID mpfid, VP *p_blk);						/* Œ蒷ubN̊l */
ER      pget_mpf(ID mpfid, VP *p_blk);						/* Œ蒷ubN̊l(|[O) */
ER      tget_mpf(ID mpfid, VP *p_blk, TMO tmout);			/* Œ蒷ubN̊l(^CAEg) */
ER      rel_mpf(ID mpfid, VP blk);							/* Œ蒷ubN̕ԋp */
ER      ref_mpf(ID mpfid, T_RMPF *pk_rmpf);					/* Œ蒷ubN̏ԎQ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_mpf_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
