/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ Z}tH                                   */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_sem_h__
#define __HOS_V4__knl_sem_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_SEMID	TMIN_SEMID			/* Z}tHID̍ŏl */
#define KERNEL_TMAX_SEMID	(KERNEL_TMIN_SEMID + kernel_semcb_cnt - 1)
												/* Z}tHID̍ől */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* Z}tH */
typedef struct t_csem
{
	ATR  sematr;		/* Z}tH */
	UINT isemcnt;		/* Z}tH̏l */
	UINT maxsem;		/* Z}tH̍ő厑 */
} T_CSEM;

/* Z}tHԏ */
typedef struct t_rsem
{
	ID   wtskid;		/* Z}tH̑҂s̐擪̃^XNIDԍ */
	UINT semcnt;		/* Z}tȞ݂̎ */
} T_RSEM;


/* Z}tHRg[ubN(ROM) */
typedef struct t_kernel_semcb_rom
{
	ATR  sematr;		/* Z}tH */
	UINT isemcnt;		/* Z}tH̏l */
	UINT maxsem;		/* Z}tH̍ő厑 */
} T_KERNEL_SEMCB_ROM;

/* Z}tHRg[ubN(RAM) */
typedef struct t_kernel_semcb_ram
{
	T_MKNL_QUE que;		/* Z}tH҂^XNL[ */
	UINT       semcnt;	/* Z}tH̎ */
	const T_KERNEL_SEMCB_ROM *semcb_rom;	/* Z}tHRg[ubNROMւ̃|C^ */
} T_KERNEL_SEMCB_RAM;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* Z}tHǗ */
extern       T_KERNEL_SEMCB_RAM *kernel_semcb_ram_tbl[];	/* Z}tHRg[ubNe[u(RAM) */
extern const INT kernel_semcb_cnt;							/* Z}tHRg[ubN */

/* Z}tHRg[ubNϊ}N */
#define KERNEL_SEMID_TO_SEMCB_RAM(semid)	(kernel_semcb_ram_tbl[(semid) - KERNEL_TMIN_SEMID])
															/* Z}tHIDSEMCB RAMAhX擾 */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* Z}tH */
void    kernel_ini_sem(void);								/* Z}tH̏ */
ER      cre_sem(ID semid, const T_CSEM *pk_csem);			/* Z}tH̐ */
ER_ID   acre_sem(const T_CSEM *pk_csem);					/* Z}tH̐(IDԍt) */
ER      kernel_cre_sem(ID semid, const T_CSEM *pk_csem);	/* Z}tH̐(J[l֐) */
ER      del_sem(ID semid);									/* Z}tH̍폜 */
ER      sig_sem(ID semid);									/* Z}tH̕ԋp */
#define isig_sem sig_sem									/* Z}tH̕ԋp(^XNReLXgp}N) */
ER      wai_sem(ID semid);									/* Z}tH̊l */
ER      pol_sem(ID semid);									/* Z}tH̊l(|[O) */
ER      twai_sem(ID semid, TMO tmout);						/* Z}tH̊l(^CAEg) */
ER      ref_sem(ID semid, T_RSEM *pk_rsem);					/* Z}tH̏ԎQ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_sem_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
