/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ VXeԊǗ                           */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_sys_h__
#define __HOS_V4__knl_sys_h__


#include "knl_hos.h"
#include "knl_tsk.h"


/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* o[W */
#define TKERNEL_MAKER	0x0008				/* [J[R[h(l) */
#define TKERNEL_PRID	0x0000				/* J[l̎ʔԍ() */
#define TKERNEL_SPVER	0x5401				/* ITRONdl̃o[W(ITRON Ver 4.01) */
#define TKERNEL_PRVER	0x0101				/* J[l̃o[Wԍ (HOS-V4 Ver 1.01) */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* o[W */
typedef struct t_rver
{
	UH    maker;		/* J[l̃[J[R[h */
	UH    prid;			/* J[l̎ʔԍ */
	UH    spver;		/* ITRONdl̃o[W */
	UH    prver;		/* J[l̃o[Wԍ */
	UH    prno[4];		/* J[li̊Ǘ */
} T_RVER;



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* VXeԊǗ@\ */
ER      rot_rdq(PRI tskpri);						/* ^XND揇ʂ̉] */
#define irot_rdq	rot_rdq							/* ^XND揇ʂ̉](^XNReLXgp}N) */
ER      get_tid(ID *p_tskid);						/* sԃ^XNID̎Q */
#define iget_tid	get_tid							/* sԃ^XNID̎Q(^XNReLXgp}N) */
ID      kernel_get_tid(T_KERNEL_TCB_RAM *tcb_ram);	/* ^XNID̎擾(J[l֐) */
ER      loc_cpu(void);								/* CPUbNԂւ̈ڍs */
#define iloc_cpu	loc_cpu							/* CPUbNԂւ̈ڍs(^XNReLXgp}N) */
ER      unl_cpu(void);								/* CPUbNԂ̉ */
#define iunl_cpu	unl_cpu							/* CPUbNԂ̉(^XNReLXgp}N)  */
ER      dis_dsp(void);								/* fBXpb`̋֎~ */
ER      ena_dsp(void);								/* fBXpb`̋ */
BOOL    sns_ctx(void);								/* ReLXg̎Q */
BOOL    sns_loc(void);								/* CPUbNԂ̎Q */
BOOL    sns_dsp(void);								/* fBXpb`֎~Ԃ̎Q */
BOOL    sns_dpn(void);								/* fBXpb`ۗԂ̎Q */

/* VXe\Ǘ@\ */
ER      ref_ver(T_RVER *pk_rver);					/* o[Wԍ̎Q */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_sys_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
