/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ ԊǗ                                   */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_tim_h__
#define __HOS_V4__knl_tim_h__



#include "knl_hos.h"



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* ^C}IuWFNg\ */
typedef struct t_kernel_tim
{
	struct t_kernel_tim *next;
	struct t_kernel_tim *prev;
	FP                  timhdr;
} T_KERNEL_TIM;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* VXeǗ */
extern const UW kernel_tic_deno;				/* RtBM[V TIC_DENO ݒ */
extern const UW kernel_tic_div;					/* RtBM[V TIC_NUME / TIC_DENO ݒ */
extern const UW kernel_tic_mod;					/* RtBM[V TIC_NUME % TIC_DENO ݒ */
extern UW       kernel_tic_cnt;					/* ^CeBbNpJE^ */
extern SYSTIM   kernel_systim;					/* VXe */


/* ^C}XgǗ */
extern T_KERNEL_TIM *kernel_tml_head;	/* ^C}Xg擪ʒu */
extern T_KERNEL_TIM *kernel_tml_ptr;	/* ^C}Xg|C^ */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* VXeǗ */
void    kernel_ini_tim(void);						/* ԊǗ@\̏ */
ER      set_tim(const SYSTIM *p_systim);			/* VXe̐ݒ */
ER      get_tim(SYSTIM *p_systim);					/* VXe̎擾 */
ER      isig_tim(void);								/* ^CeBbN̋ */

/* ^C}Xg */
void    kernel_add_tml(T_KERNEL_TIM *timobj);		/* ^C}IuWFNg̃Xgւ̒ǉ */
void    kernel_rmv_tml(T_KERNEL_TIM *timobj);		/* ^C}IuWFNg̃Xg̍폜 */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_tim_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
