/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ ^XNǗ                                 */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_tsk_h__
#define __HOS_V4__knl_tsk_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                  萔`                  */
/* ------------------------------------------ */

/* ID͈̔ */
#define KERNEL_TMIN_TSKID	TMIN_TSKID			/* ^XNID̍ŏl */
#define KERNEL_TMAX_TSKID	(KERNEL_TMIN_TSKID + kernel_tcb_cnt - 1)
												/* ^XNID̍ől */

/* rbgp^[̃rbg */
#define TBIT_TEXPTN			16					/* ^XNOṽrbg */
												/* ^XNID̍ől */


/* L[CO^lXg񐔂̍ől */
#define TMAX_ACTCNT			255					/* ^XNNvL[CO̍ől */
#define TMAX_WUPCNT			65535				/* ^XNNvL[CO̍ől */
#define TMAX_SUSCNT			255					/* ^XN҂vlXg̍ől */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* ^XN */
typedef struct t_ctsk
{
	ATR     tskatr;			/* ^XN */
	VP_INT  exinf;			/* ^XN̊g */
	FP      task;			/* ^XN̋NԒn */
	PRI     itskpri;		/* ^XN̋NDx */
	SIZE    stksz;			/* X^bN̈̃TCY(oCg) */
	VP      stk;			/* X^bN̈̐擪Ԓn */
} T_CTSK;

/* ^XN */
typedef struct t_rtsk
{
	STAT   tskstat;			/* ^XN */
	PRI    tskpri;			/* ^XŇݗDx */
	PRI	   tskbpri;			/* ^XÑx[XDx */
	STAT   tskwait;			/* ҂v */
	ID     wobjid;			/* ҂Ώۂ̃IuWFNgIDԍ */
	TMO    lefttmo;			/* ^CAEg܂ł̎ */
	UINT   actcnt;			/* NvL[CO */
	UINT   wupcnt;			/* NvL[CO */
	UINT   suscnt;			/* ҂vlXg */
	VP_INT exinf;			/* ^XN̊g */
} T_RTSK;

/* ^XN(ȈՔ) */
typedef struct t_rtst
{
	STAT   tskstat;			/* ^XN */
	STAT   tskwait;			/* ҂v */
	VP_INT exinf;			/* ^XN̊g */
} T_RTST;

/* ^XNO[`` */
typedef	struct t_detx
{
	ATR		texatr;
	FP		texrtn;
} T_DTEX;

/* ^XNORg[ubN(RAM) */
typedef struct t_kernel_texcb_ram
{
	TEXPTN rasptn;			/* ^XNÕ^XNOv */
	FP     texrtn;			/* ^XNŐNԒn */
} T_KERNEL_TEXCB_RAM;


/* ^XNRg[ubN(ROM) */
typedef struct t_kernel_tcb_rom
{
	ATR    tskatr;			/* ^XN */
	VP_INT exinf;			/* ^XN̊g */
	FP     task;			/* ^XN̋NԒn */
	PRI    itskpri;			/* ^XN̋NDx */
	SIZE   stksz;			/* ^XÑX^bÑTCYioCgj */
	VP	   stk;				/* ^XÑX^bN̈̐擪Ԓn */
} T_KERNEL_TCB_ROM;


/* ^XNRg[ubN(RAM) */
typedef struct t_kernel_tcb_ram
{
	T_MKNL_TCB mtcb;		/* ʃJ[l ^XNRg[ubN */	
	UB         actcnt;		/* NvL[CO */
	UB         suscnt;		/* SUSPENDvlXg */
	UH         wupcnt;		/* NvL[CO */
	T_KERNEL_TEXCB_RAM     *texcb;		/* ^XNORg[ubNւ̃|C^ */
	const T_KERNEL_TCB_ROM *tcb_rom;	/* ^XNRg[ubNROMւ̃|C^ */
} T_KERNEL_TCB_RAM;



/* ---------------------------------- */
/*        O[oϐ錾          */
/* ---------------------------------- */

/* ^XNǗ */
extern       T_KERNEL_TCB_RAM* kernel_tcb_ram_tbl[];		/* ^XNRg[ubNe[u(RAM) */
extern const INT kernel_tcb_cnt;							/* ^XNRg[ubN */

/* ϊ}N */
#define KERNEL_TSKID_TO_TCB_RAM(tskid)	(kernel_tcb_ram_tbl[(tskid) - KERNEL_TMIN_TSKID])
															/* ^XNIDTCB RAMAhX擾 */



/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ^XNǗ@\ */
void    kernel_ini_tsk(void);								/* ^XN̏ */
ER      cre_tsk(ID tskid, const T_CTSK *pk_ctsk);			/* ^XN̐ */
ER_ID   acre_tsk(const T_CTSK *pk_ctsk);					/* ^XN̐(IDԍt) */
ER      kernel_cre_tsk(ID tskid, const T_CTSK *pk_ctsk);	/* ^XN(J[l) */
ER      del_tsk(ID tskid);									/* ^XN̍폜 */
ER      act_tsk(ID tskid);									/* ^XN̋N */
#define	iact_tsk	act_tsk									/* ^XN̋N(^XNReLXgp}N) */
ER_UINT can_act(ID tskid);									/* ^XNNṽLZ */
ER      sta_tsk(ID tskid, VP_INT stacd);					/* ^XN̋N(NR[hw) */
void    ext_tsk(void);										/* ^XN̏I */
void    exd_tsk(void);										/* ^XN̏Iƍ폜 */
ER      ter_tsk(ID tskid);									/* ^XN̋I */
ER      chg_pri(ID tskid, PRI tskpri);						/* ^XNDx̕ύX */
ER      get_pri(ID tskid, PRI *p_tskpri);					/* ^XNDx̎Q */
ER      ref_tsk(ID tskid, T_RTSK *p_rtsk);					/* ^XN̏ԎQ */
ER      ref_tst(ID tskid, T_RTST *p_rtst);					/* ^XN̏ԎQ(ȈՔ) */

/* ^XNt@\ */
ER      slp_tsk(void);										/* ^XN̋N҂ */
ER      tslp_tsk(TMO tmout);								/* ^XN̋N҂(^CAEg) */
ER      wup_tsk(ID tskid);									/* ^XN̋N */
#define	iwup_tsk	wup_tsk									/* ^XN̋N(^XNReLXgp}N) */
ER_UINT can_wup(ID tskid);									/* ^XNNṽLZ */
ER      rel_wai(ID tskid);									/* ҂Ԃ̋ */
#define	irel_wai	rel_wai									/* ҂Ԃ̋(^XNReLXgp}N) */
ER      sus_tsk(ID tskid);									/* ҂Ԃւ̈ڍs */
ER      rsm_tsk(ID tskid);									/* ҂Ԃ̍ĊJ */
ER      frsm_tsk(ID tskid);									/* ҂Ԃ̋ĊJ */
ER      dly_tsk(RELTIM dlytim);								/* ^XN̒x */

/* ^XNO@\ */
ER      ras_tex(ID tskid, TEXPTN rasptn);					/* ^XNO̗v */
#define iras_tex	ras_tex									/* ^XNO̗v(^XNReLXgp}N) */
ER      dis_tex(void);										/* ^XNŐ֎~ */
ER      ena_tex(void);										/* ^XNŐ֎~ */
BOOL    sns_tex(void);										/* ^XNO֎~Ԃ̎Q */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_tsk_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
