/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ʃJ[lˑ`wb_                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__mknl_h__
#define __HOS_V4__mknl_h__



#include "itron.h"
#include "hosdenv.h"



/* ------------------------------------------ */
/*                萔`                    */
/* ------------------------------------------ */

/* ^XNDx͈̔ */
#define TMIN_TPRI			1					/* ^XNDx̍ŏl */
#define TMAX_TPRI			(TMIN_TPRI + mknl_rdq_cnt - 1)
												/* ^XNDx̍ől */


/* VXȅ */
#define MKNL_TSS_TSK		0x00				/* ^XNs */
#define MKNL_TSS_INDP		0x04				/* ^XNƗs */
#define MKNL_TSS_DDSP		0x01				/* fBXpb`֎~ (dis_dsp L) */
#define MKNL_TSS_DINT		0x03				/* 荞݋֎~(loc_cpu L) */
#define MKNL_TSS_DDLY		0x80				/* fBXpb`x */
#define MKNL_TSS_ZOMB		0x10				/* ]r^XNs */

/* ^XN̗O */
#define MKNL_TTS_RDLY		0x01				/* Oۗ */
#define MKNL_TTS_DRAS		0x03				/* O֎~ */



/* ------------------------------------------ */
/*                 ^`                     */
/* ------------------------------------------ */

/* L[ǗubN */
typedef struct t_mknl_que
{
	struct t_mknl_tcb *head;	/* L[̐擪 */
} T_MKNL_QUE;


/* ʃJ[l ^XNRg[ubN */
typedef struct t_mknl_tcb
{
	T_HOSPAC_CTXINF   ctxinf;		/* ReLXgۑubN */
	STAT              tskwait;		/* ҂v */
	UB                tskstat;		/* ^XN̏ */
	UB                texstat;		/* Ȍ */
	PRI               tskpri;		/* ݂̗Dx */
	ER_UINT           ercd;			/* ҂vpG[R[h */
	VP_INT            data;			/* ėpf[^̈ */
	struct t_mknl_que *que;			/* ĂL[  */
	struct t_mknl_tcb *next;		/* L[ł̎TCB */
	struct t_mknl_tcb *prev;		/* L[ł̑OTCB */
	struct t_mknl_tcb *tm_next;		/* ^CAEgL[̎TCB */
	struct t_mknl_tcb *tm_prev;		/* ^CAEgL[̑OTCB */
	RELTIM            diftim;		/* OTCBƂ̃^CAEg܂ł̎ԍ */
} T_MKNL_TCB;


/* ^CAEgǗp\ */
typedef struct t_mknl_timout
{
	T_MKNL_TCB *mtcb;		/* ^CAEg҂̃^XN */
	RELTIM     diftim;		/* z񒼑Ȏ҂^XNƂ̎ԍ */
} T_MKNL_TIMOUT;



/* ------------------------------------------ */
/*              Oϐ錾                  */
/* ------------------------------------------ */

/* VXeǗ */
extern STAT            mknl_ctx_stat;		/* VXẽReLXg */
extern T_MKNL_TCB      *mknl_run_mtcb;		/* s^XNRg[ubN */

/* ACh[vǗ */
extern T_HOSPAC_CTXINF mknl_idlctx;			/* ACh[ṽReLXg */
extern const VP        mknl_idl_stk;		/* ACh[ṽX^bN */
extern const SIZE      mknl_idl_stksz;		/* ACh[ṽX^bNTCY */

/* ^XNǗ */
extern T_MKNL_QUE      mknl_rdq_tbl[];		/* fB[L[e[u */
extern const INT       mknl_rdq_cnt;		/* fB[L[ */

extern       INT       mknl_timout_tskcnt;	/* ^CAEg҂s̃^XN */

/* ^CAEgǗ */
extern T_MKNL_TCB      *mknl_timout_head;	/* ^CAEgL[̐擪 */


/* ------------------------------------------ */
/*                ֐錾                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ʃJ[l̃T[rXR[͌ mknl_sys_loc()  */
/* bNꂽԂŌĂяo邱                 */

/* VXe */
void    mknl_ini_sys(void);									/* ʃJ[lVXȅ */
void    mknl_sta_startup(void);								/* X^[gAbv[`̊Jn */
void    mknl_ext_startup(void);								/* X^[gAbv[`̏I */
void    mknl_idl_loop(void);								/* ACh[v */

/* ^XN */
#define mknl_ini_tsk(mtcb)	do { (mtcb)->tskstat = TTS_DMT; } while (0)
															/* ^XN̏(}N֐) */
void    mknl_sta_tsk(T_MKNL_TCB *mtcb, VP_INT exinf,
							FP task, PRI tskpri,
							SIZE stksz, VP stk);			/* ^XN̊Jn */
void    mknl_ter_tsk(T_MKNL_TCB *mtcb);						/* ^XN̏I */
void    mknl_chg_pri(T_MKNL_TCB *mtcb, PRI tskpri);			/* ^XNDxύX */
void    mknl_wai_tsk(T_MKNL_TCB *mtcb, STAT tskwait);		/* ^XN̑҂ */
void    mknl_wup_tsk(T_MKNL_TCB *mtcb, ER_UINT ercd);		/* ^XN̑҂ */
void    mknl_sus_tsk(T_MKNL_TCB *mtcb);						/* ^XN̋҂ */
void    mknl_rsm_tsk(T_MKNL_TCB *mtcb);						/* ^XN̋҂ */
void    mknl_rot_rdq(PRI tskpri);							/* ^XND揇ʂ̉] */
ER_UINT mknl_exe_dsp(void);									/* ^XNfBXpb`̎s */
void    mknl_dly_dsp(void);									/* xĂfBXpb`̎s */
T_MKNL_TCB* mknl_srh_top(void);								/* fB[L[擪̃^XNT */
#define mknl_get_run_tsk()		(mknl_run_mtcb)				/* s^XN̎擾(}N֐) */
#define mknl_get_pri(mtcb)		((PRI)(mtcb)->tskpri)		/* ^XNDx擾(}N֐) */
#define mknl_get_tskstat(mtcb)	((STAT)(mtcb)->tskstat)		/* ^XNԎ擾(}N֐) */
#define mknl_get_tskwait(mtcb)	((STAT)(mtcb)->tskwait)		/* ҂v擾(}N֐) */

void    kernel_task_entry(VP_INT exinf);					/* ^XÑGg[|Cg(J[lŗpӂ邱) */


/* ^XNO */
void    mknl_ras_tex(T_MKNL_TCB *mtcb);						/* ^XNO̗v */
void    mknl_exe_tex(void);									/* ^XNO̎s */
#define mknl_dis_tex(mtcb)	\
	do { (mtcb)->texstat |= MKNL_TTS_DRAS; } while (0)		/* ^XNŐ֎~ */
#define mknl_ena_tex(mtcb)	\
	do { (mtcb)->texstat &= ~MKNL_TTS_DRAS; } while (0)		/* ^XNŐ */
#define mknl_sns_tex()	\
	((mknl_run_mtcb == NULL || (mknl_run_mtcb->texstat & MKNL_TTS_DRAS)) ? TRUE: FALSE)
															/* ^XNO֎~Ԃ̎Q */

void    kernel_tex_entry(void);								/* ^XNOGg[|Cg(J[lŗpӂ邱) */
	

/* VXe */
#define mknl_loc_sys()	\
	do { if ( !(mknl_ctx_stat & MKNL_TSS_DINT) ) { hospac_dis_int(); } } while (0)
															/* VXẽbN(}N֐) */
#define mknl_unl_sys()	\
	do { if ( !(mknl_ctx_stat & MKNL_TSS_DINT) ) { hospac_ena_int(); } } while (0)
															/* VXẽbN(}N֐) */
#define mknl_dis_int()	do { hospac_dis_int(); } while (0)	/* 荞݋֎~ */
#define mknl_ena_int()	do { hospac_ena_int(); } while (0)	/* 荞݋ */
#define mknl_sta_ind()	do { mknl_ctx_stat |= MKNL_TSS_INDP; } while (0)
															/* ^XN̊Jn(}N֐) */
#define mknl_ext_ind()	do { mknl_ctx_stat &= ~MKNL_TSS_INDP; } while (0)
															/* ^XN̏I(}N֐) */
#define mknl_loc_cpu()	do { mknl_ctx_stat |= MKNL_TSS_DINT; } while (0)
															/* CPŨbN(}N֐) */
#define mknl_unl_cpu()	do { mknl_ctx_stat &= ~MKNL_TSS_DINT; } while (0)
															/* CPŨbN(}N֐) */
#define mknl_dis_dsp()	do { mknl_ctx_stat |= MKNL_TSS_DDSP; } while (0)
															/* fBXpb`̋֎~(}N֐) */
#define mknl_ena_dsp()	do { mknl_ctx_stat &= ~MKNL_TSS_DDSP; } while (0)
															/* fBXpb`̋(}N֐) */
#define mknl_sns_ctx()	((mknl_ctx_stat & MKNL_TSS_INDP) ? TRUE : FALSE)
															/* ReLXg̎Q(}N֐) */
#define mknl_sns_loc()	((mknl_ctx_stat & MKNL_TSS_DINT) ? TRUE : FALSE)
															/* CPUbNԂ̎Q(}N֐) */
#define mknl_sns_dsp()	((mknl_ctx_stat & MKNL_TSS_DDSP) ? TRUE : FALSE)
															/* fBXpb`֎~Ԃ̎Q(}N֐) */
#define mknl_sns_dpn()	((mknl_ctx_stat & MKNL_TSS_DDLY) ? TRUE : FALSE)
															/* fBXpb`ۗԂ̎Q(}N֐) */
#define mknl_sns_wai()	((mknl_ctx_stat & (MKNL_TSS_INDP | MKNL_TSS_DDSP | MKNL_TSS_DINT)) ? TRUE : FALSE)
															/* ҂Ԉڍs\Q(}N֐) */


/* L[ */
#define mknl_ini_que(que)	do { (que)->head = NULL; } while (0)
void    mknl_clr_que(T_MKNL_QUE *que);						/* L[̍폜 */
															/* L[̏ */
void    mknl_add_que(T_MKNL_QUE *que, T_MKNL_TCB *mtcb, ATR atr);
															/* ^XNL[ɒǉ */
void    mknl_adf_que(T_MKNL_QUE *que, T_MKNL_TCB *mtcb);	/* ^XNFIFOŃL[ɒǉ */
void    mknl_adp_que(T_MKNL_QUE *que, T_MKNL_TCB *mtcb);	/* ^XNDxŃL[ɒǉ */
void    mknl_rmv_que(T_MKNL_TCB *mtcb);						/* ^XNL[菜 */
void    mknl_rot_que(T_MKNL_QUE *que);						/* fB[L[̉] */
#define mknl_ref_qhd(que)	((que)->head)					/* L[̐擪^XN̎Q(}N֐) */
#define mknl_ref_nxt(que, mtcb)		\
		((mtcb)->next != (que)->head ? (que)->head : NULL)	/* ̃L[擾 */

/* ^CAEg҂s */
void    mknl_tic_tmout(RELTIM tictim);						/* ^CAEgɃ^CeBbN */
ER      mknl_add_tmout(T_MKNL_TCB *mtcb, RELTIM tmout);		/* ^CAEg҂sɃ^XNǉ */
void    mknl_rmv_tmout(T_MKNL_TCB *mtcb);					/* ^CAEg҂s񂩂^XN菜 */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__mknl_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
