/* ------------------------------------------------------------------------ */
/*  H8/3664p SCI3䃉Cu                                             */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */
#include "kernel.h"
#include "iodefine.h"
#include "h8t_sci.h"

#define RECV_BUFSIZE	32		/* Mobt@̃TCY */

static unsigned char recv_buf[RECV_BUFSIZE];
static int head;
static int tail;

/* SCI3 */
void SCI3_Initialize(unsigned char rate)
{
	volatile int i;
	
	/* SCI3 */
	SCI3.SCR3.BYTE = 0x00;
	SCI3.SMR.BYTE = 0x00;
	SCI3.BRR = rate;
	for ( i = 0; i < 280; i++ )
		;
	SCI3.SCR3.BYTE = 0x30; /* M|M */
	IO.PMR1.BIT.TXD = 1;
}

/* Po */
void SCI3_PutChar(char c)
{
	while ( !(SCI3.SSR.BYTE & 0x80) )
		;

	SCI3.TDR  = c;
/*      SCI3.SSR.BYTE &= 0x7f;  */
}

/* P */
int SCI3_GetChar(void)
{
	if ( head == tail )
	{
		return -1;
	}
	
	return recv_buf[head++];
}


/* SCIM荞 */
void SCI3_RxiHandler(VP_INT exinf)
{
	unsigned char c;
	int next;
	
	/* 1M */
	c = SCI3.RDR;
	SCI3.SSR.BYTE &= 0xbf;
	
	/* ̖ʒuvZ */
	next = tail + 1;
	if ( next >= RECV_BUFSIZE )
	{
		next = 0;
	}
	
	/* I[o[t[`FbN */
	if ( next == head )
	{
		return;
	}
	
	/* Mobt@Ɋi[ */
	recv_buf[tail] = c;
	tail = next;
}
