/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  TvvO                           */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */

#include "kernel.h"
#include "kernel_id.h"
#include "iodefine.h"
#include "h8t_sci.h"

/* C֐ */
int main()
{
	/* SCȈ */
	Sci_Initialize(SCI_38400);

	/* JnbZ[W */
	Sci_PutChar('H');
	Sci_PutChar('O');
	Sci_PutChar('S');
	Sci_PutChar('\r');
	Sci_PutChar('\n');

	sta_hos();
	
	return 0;
}


/* nh */
void Initialize(VP_INT exinf)
{
}


/* Tv^XN */
void Task1(VP_INT exinf)
{
	SYSTIM st;

	for ( ; ; )
	{
		IO.PDR8.BIT.B7 ^= 1;
		/* ^C}l擾 */
		get_tim(&st);
		
		/* ^C}lo */
		Sci_PutChar('0' + (st.ltime / 10000) % 10);
		Sci_PutChar('0' + (st.ltime / 1000) % 10);
		Sci_PutChar('0' + (st.ltime / 100) % 10);
		Sci_PutChar('0' + (st.ltime / 10) % 10);
		Sci_PutChar('0' + (st.ltime / 1) % 10);
		Sci_PutChar(':');
		
		/* ^XNbZ[W */
		Sci_PutChar('T');
		Sci_PutChar('a');
		Sci_PutChar('s');
		Sci_PutChar('k');
		Sci_PutChar(exinf);
		Sci_PutChar('\r');
		Sci_PutChar('\n');
		
		/* 1b҂ */
		dly_tsk(1000);
	}
}

/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
