; --------------------------------------------------------------------------- 
;  Hyper Operating System V4  ITRON4.0dl Real-Time OS                     
;    vZbTۉR|[lg (ARMp)                                   
;    Onh                                                             
;                                                                             
;                                     Copyright (C) 1998-2002 by Project HOS  
;                                     http://sourceforge.jp/projects/hos/     
; --------------------------------------------------------------------------- 


				INCLUDE	pacarm.inc



				AREA	inthdr_code, CODE, READONLY

				EXPORT	_HOS_CpuExceptionHandler

; ----------------------------------------------
;  CPUOnh
; ----------------------------------------------
				IMPORT	kernel_sta_exc				; CPUOnhJn
				IMPORT	kernel_end_exc				; CPUOnhI
				IMPORT	kernel_exe_exc				; CPUOnh̎s
				IMPORT	kernel_int_sp				; 荞ݗpX^bNAhX
				IMPORT	_HOS_int_cnt				; 荞݃lXg
				IMPORT	_HOS_int_sp					; 荞ݎX^bNޔ
				
_HOS_CpuExceptionHandler
			; ---- System[hɈڍsăWX^ޔ
				mov		r13, #I_Bit:OR:F_Bit:OR:Mode_SYS
				msr		cpsr_csxf, r13
				stmfd	sp!, {r1-r3, ip, lr}		; ėpWX^ޔ

			; ---- ̃[hɖ߂spsrۑ
				mov		r1, #I_Bit:OR:F_Bit:OR:Mode_UND
				msr		cpsr_c, r1
				mrs		r1, spsr					; spsr o
				mov		r2, lr						; 荞ݕAۑ
				
			; ---- USR[hɈڍs
				mov		r3, #I_Bit:OR:F_Bit:OR:Mode_USR
				msr		cpsr_c, r3
				
			; ---- WX^ޔ
				stmfd	sp!, {r0-r2}				; a1, spsr_irq, lr_irq ۑ
				
			; ---- d荞݃`FbN
				ldr		r0, =_HOS_int_cnt
				ldr		r1, [r0]					; 荞݃lXgJE^擾
				cmp		r1, #0
				add		r1, r1, #1					; 荞݃lXgJE^CNg
				str		r1, [r0]
				bne		MultipleInt					; 荞ݒȂ番
				
			; ---- X^bN̓ւ
				ldr		r0, =_HOS_int_sp
				str		sp, [r0]					; X^bN|C^ޔ
				ldr		r0, =kernel_int_sp
				ldr		sp, [r0]					; 荞ݗpX^bNݒ

			; ---- CPUOnh̊Jn
				bl		kernel_sta_exc				; CPUOnhJn
				bl		kernel_exe_exc				; 荞ݏs
			
			; ---- X^bN̕A
				ldr		r0, =_HOS_int_sp
				ldr		sp, [r0]					; X^bN|C^𕜋A
			
			; ---- 荞݃lXgJEgfNg
				ldr		r0, =_HOS_int_cnt
				mov		r1, #0
				str		r1, [r0]					; 荞݃lXgJE^NA
			
			; ---- xfBXpb`s
				bl		kernel_end_exc				; xfBXpb`s
			
			; ---- CPUOnh̕A
ReturnExc		
				IMPORT	_HOS_swi_ret
				ldmfd	sp!, {r0-r2}
				ldr		r3, =_HOS_swi_ret
				stmia	r3, {r0-r2}					; 荞ݕAf[^ݒ
				ldmfd	sp!, {r1-r3, ip, lr}		; WX^A
				mov		a1, #2
				swi		0x10


			;---- 荞ݒ̏
MultipleInt
			; ---- 荞ݏ
				bl		kernel_sta_exc				; CPUOnhJn

			; ---- 荞݃lXgJEgfNg
				ldr		r0, =_HOS_int_sp
				ldr		r1, [r0]
				add		r1, r1, #1
				str		r1, [r0]

				b		ReturnExc



				END


; --------------------------------------------------------------------------- 
;  Copyright (C) 1998-2002 by Project HOS                                     
; --------------------------------------------------------------------------- 
