/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    vZbTۉR|[lg (ARM gccp)                            */
/*    FIQOnh                                                       */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */



#include "pacarm.inc"


				.text
				.align	4

				.global	_HOS_FiqHandler

/************************************************
  FIQ nh
*************************************************/
				.extern	hos_arm_sta_fiq				/* FIQ̏ */
				.extern	hos_arm_end_fiq				/* FIQ̏I */
				.extern	kernel_sta_int				/* 荞݊Jn */
				.extern	kernel_end_int				/* 荞ݏI */
				.extern	kernel_exe_int				/* 荞ݏ̎s */
				.extern	kernel_int_sp				/* 荞ݗpX^bNAhX */
				.extern	kernel_int_cnt				/* 荞݃lXg */
				.extern	kernel_int_ssp				/* 荞ݎX^bNޔ */
				
_HOS_FiqHandler:
				sub		lr, lr, #4					/* ^[AhXZo */
			
			/* System[hɈڍsăWX^ޔ */
				mov		r13, #(I_Bit | F_Bit | Mode_SYS)
				msr		cpsr_csxf, r13
				stmfd	sp!, {r1-r3, ip, lr}		/* ėpWX^ޔ */

			/* FIQ[hɖ߂spsrۑ */
				mov		r1, #(I_Bit | F_Bit | Mode_FIQ)
				msr		cpsr_c, r1
				mrs		r1, spsr					/* spsr o */
				mov		r2, lr						/* 荞ݕAۑ */
				
			/* USR[hɈڍs */
				mov		r3, #(I_Bit | F_Bit | Mode_USR)
				msr		cpsr_c, r3
				
			/* WX^ޔ */
				stmfd	sp!, {r0-r2}				/* a1, spsr_irq, lr_irq ۑ */
				
			/* d荞݃`FbN */
				ldr		r0, =kernel_int_cnt
				ldr		r1, [r0]					/* 荞݃lXgJE^擾 */
				cmp		r1, #0
				add		r1, r1, #1					/* 荞݃lXgJE^CNg */
				str		r1, [r0]
				bne		MultipleInt					/* d荞݂Ȃ番 */
				
			/* X^bN̓ւ */
				ldr		r0, =kernel_int_ssp
				str		sp, [r0]					/* X^bN|C^ޔ */
				ldr		r0, =kernel_int_sp
				ldr		sp, [r0]					/* 荞ݗpX^bNݒ */

			/* 荞ݏ̊Jn */
				bl		kernel_sta_int
				
			/* 荞ݏ */
				bl      hos_arm_sta_fiq				/* FIQJn(ݔԍ擾) */
				bl		kernel_exe_int				/* 荞ݏs */
				bl		hos_arm_end_fiq				/* FIQI */
			
			/* X^bN̕A */
				ldr		r0, =kernel_int_ssp
				ldr		sp, [r0]					/* X^bN|C^𕜋A */
			
			/* 荞݃lXgJEgfNg */
				ldr		r0, =kernel_int_cnt
				mov		r1, #0
				str		r1, [r0]					/* 荞݃lXgJE^NA */
			
			/* xfBXpb`s */
				bl		kernel_end_int				/* xfBXpb`s */
			
			/* 荞݂̕A */
ReturnInt:
				.extern	pac_arm_swi_ret
				ldmfd	sp!, {r0-r2}
				ldr		r3, =pac_arm_swi_ret
				stmia	r3, {r0-r2}					/* 荞ݕAf[^ݒ */
				ldmfd	sp!, {r1-r3, ip, lr}		/* WX^A */
				mov		a1, #2
				swi		0x10


			/* d荞ݏ */
MultipleInt:
			/* 荞ݏ */
				bl      hos_arm_sta_fiq				/* FIQJn(ݔԍ擾) */
				bl		kernel_exe_int				/* 荞ݏs */
				bl		hos_arm_end_fiq				/* FIQI */

			/* 荞݃lXgJEgfNg */
				ldr		r0, =kernel_int_cnt
				ldr		r1, [r0]
				sub		r1, r1, #1
				str		r1, [r0]

				b		ReturnInt



				.end


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
