/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*   vZbTۉR|[lg (ARMp)                                 */
/*   荞݃}XNǗ                                                     */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"



/* O[oϐ` */
UW hospac_arm_imsk  = ARM_IMSK_USR_MODE;		/* 荞݃}XN */
UW hospac_arm_bimsk = ARM_IMSK_USR_MODE;		/* x[X荞݃}XN */


/* 荞݃}XNw */
ER chg_imsk(IMSK imsk)
{
	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( (imsk & ~(ARM_IMSK_FIQ | ARM_IMSK_IRQ)) != 0 )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();		/* VXẽbN */

	hospac_arm_bimsk = (imsk | ARM_IMSK_USR_MODE);
	
	if ( !mknl_sns_ctx() )
	{
		hospac_arm_imsk = hospac_arm_bimsk;
	}
	else
	{
		hospac_arm_imsk |= hospac_arm_bimsk;
	}

	mknl_unl_sys();		/* VXẽAbN */

	return E_OK;
}


/* 荞݃}XN̎Q */
ER get_imsk(IMSK *p_imsk)
{
	*p_imsk = (hospac_arm_bimsk & (ARM_IMSK_FIQ | ARM_IMSK_IRQ));
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
