/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l A[nh                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_alm.h"



/* A[nh̃^C}nh */
void kernel_alm_hdr(
		T_KERNEL_TIM *timobj,	/* ^C}IuWFNg */
		RELTIM       tic)		/* ^CeBbN */
{
	const T_KERNEL_ALMCB_ROM *almcb_rom;
	T_KERNEL_ALMCB_RAM *almcb_ram;
	
	/* upper cast */
	almcb_ram = (T_KERNEL_ALMCB_RAM *)timobj;
	
	/* A[^XN̎s */
	if ( almcb_ram->lefttim <= tic )
	{
		almcb_rom = almcb_ram->almcb_rom;
				
		/* A[nh^C}XgO */
		kernel_rmv_tml((T_KERNEL_TIM *)almcb_ram);

		/* A[nhĂяo */
		mknl_unl_sys();							/* VXẽbN */		
		almcb_rom->almhdr(almcb_rom->exinf);	/* nhĂяo */
		mknl_loc_sys();							/* VXẽbN */
	}
	else
	{
		almcb_ram->lefttim -= tic;		/* c莞ԂZ */
	}
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
