/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l A[nh                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_alm.h"



/* A[nh̓Jn */
ER sta_alm(
		ID     almid,	/* JnΏۂ̃A[nhIDԍ */
		RELTIM almtim)	/* A[nh̋N(Ύ) */
{
	const T_KERNEL_ALMCB_ROM *almcb_rom;
	T_KERNEL_ALMCB_RAM *almcb_ram;
	
	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( almid < KERNEL_TMIN_ALMID || almid > KERNEL_TMAX_ALMID )
	{
		return E_ID;
	}
#endif
	
	mknl_loc_sys();	/* VXẽbN */
	
	almcb_ram = KERNEL_ALMID_TO_ALMCB_RAM(almid);
	
	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( almcb_ram == NULL )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_NOEXS;
	}
#endif
	
	almcb_rom = almcb_ram->almcb_rom;
	
	/* ^C}JE^ݒ */
	almcb_ram->lefttim = almtim;
	
	/* ^C}Xgɓo^ */
	kernel_add_tml((T_KERNEL_TIM *)almcb_ram);
	
	mknl_unl_sys();		/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
