/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l nh                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_cyc.h"


/* nh̐(IDԍt) */
ER_ID acre_cyc(
		const T_CCYC *pk_ccyc)	/* nhꂽpPbgւ̃|C^ */
{
	ID cycid;
	ER ercd;

	mknl_loc_sys();	/* VXẽbN */

	/* IĎ */
	for ( cycid = KERNEL_TMAX_CYCID; cycid >= KERNEL_TMIN_CYCID; cycid-- )
	{
		if ( KERNEL_CYCID_TO_CYCCB_RAM(cycid) == NULL )
		{
			break;
		}
	}
	if ( cycid < KERNEL_TMIN_CYCID )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_NOID;		/* IDԍs */
	}
	
	/* nh̐ */
	ercd = kernel_cre_cyc(cycid, pk_ccyc);

	mknl_unl_sys();	/* VXẽbN */

	if ( ercd != E_OK )
	{
		return (ER_ID)ercd;	/* G[ */
	}

	return (ER_ID)cycid;		/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
