/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l nh                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_cyc.h"



/* nh̃^C}nh */
void kernel_cyc_hdr(
		T_KERNEL_TIM *timobj,	/* ^C}IuWFNg */
		RELTIM       tic)		/* ^CeBbN */
{
	const T_KERNEL_CYCCB_ROM *cyccb_rom;
	T_KERNEL_CYCCB_RAM *cyccb_ram;
	
	/* upper cast */
	cyccb_ram = (T_KERNEL_CYCCB_RAM *)timobj;
	
	/* ^XN̎s */
	if ( cyccb_ram->lefttim <= tic )
	{
		cyccb_rom = cyccb_ram->cyccb_rom;
				
		/* ̒lݒ */
		cyccb_ram->lefttim += cyccb_rom->cyctim - tic;

		/* nhĂяo */
		mknl_unl_sys();							/* VXẽbN */		
		cyccb_rom->cychdr(cyccb_rom->exinf);	/* nhĂяo */
		mknl_loc_sys();							/* VXẽbN */
	}
	else
	{
		cyccb_ram->lefttim -= tic;
	}
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
