/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l nh                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_cyc.h"
#include "knl_mem.h"



/* nh̍폜 */
ER del_cyc(
		ID cycid)	/* 폜Ώۂ̎nhIDԍ */
{
	T_KERNEL_CYCCB_RAM *cyccb_ram;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( cycid < KERNEL_TMIN_CYCID || cycid > KERNEL_TMAX_CYCID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();		/* VXẽbN */

	cyccb_ram = KERNEL_CYCID_TO_CYCCB_RAM(cycid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( cyccb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	/* ^C}XgO */
	kernel_rmv_tml((T_KERNEL_TIM *)cyccb_ram);
	
	/* ̉ */
	kernel_fre_mem(cyccb_ram);

	KERNEL_CYCID_TO_CYCCB_RAM(cycid) = NULL;
	
	mknl_unl_sys();		/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
