/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l nh                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_cyc.h"
#include "knl_mem.h"



/* nh̐(J[l) */
ER kernel_cre_cyc(
		ID           cycid,		/* Ώۂ̎nhIDԍ */
		const T_CCYC *pk_ccyc)	/* nhꂽpPbgւ̃|C^ */
{
	T_KERNEL_CYCCB_RAM *cyccb_ram;
	T_KERNEL_CYCCB_ROM *cyccb_rom;
	SIZE memsize;
	UB   *memptr;
	
	/* KvȃTCYvZ */
	memsize = sizeof(T_KERNEL_CYCCB_RAM) + sizeof(T_KERNEL_CYCCB_ROM);
	
	/* m */
	memptr = (UB *)kernel_alc_mem(memsize);
#ifdef HOS_ERCHK_E_NOMEM
	if ( memptr == NULL )
	{
		return E_NOMEM;		/* s */
	}
#endif

	/* |C^ݒ */	
	cyccb_ram  = (T_KERNEL_CYCCB_RAM *)memptr;
	memptr  += sizeof(T_KERNEL_CYCCB_RAM);
	cyccb_rom  = (T_KERNEL_CYCCB_ROM *)memptr;

	/* lݒ */
	cyccb_ram->timobj.timhdr = kernel_cyc_hdr; /* nho^ */
	cyccb_ram->timobj.next   = NULL;            /* ^C}Xgڑ */
	cyccb_ram->cyccb_rom     = cyccb_rom;	/* nhRg[ubNROMւ̃|C^ */
	cyccb_rom->cycatr  = pk_ccyc->cycatr;	/* nh */
	cyccb_rom->exinf   = pk_ccyc->exinf;	/* nh̊g */
	cyccb_rom->cychdr  = pk_ccyc->cychdr;	/* nh̋NԒn */
	cyccb_rom->cyctim  = pk_ccyc->cyctim;	/* nh̋N */
/*	cyccb_rom->cycphs  = pk_ccyc->cycphs;*/	/* nh̋Nʑ */

	/* nhRg[ubNe[uɓo^ */
	KERNEL_CYCID_TO_CYCCB_RAM(cycid) = cyccb_ram;

	/* sȂΊJn */
	if ( pk_ccyc->cycatr & TA_STA )
	{
		/* ^C}Xgɒǉ */
		cyccb_ram->lefttim = pk_ccyc->cyctim;
		kernel_add_tml((T_KERNEL_TIM *)cyccb_ram);
	}

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
