/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l f[^L[                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"



/* f[^L[̐ */
ER cre_dtq(
		ID           dtqid,		/* Ώۂ̃f[^L[IDԍ */
		const T_CDTQ *pk_cdtq)	/* f[^L[ꂽpPbgւ̃|C^ */
{
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* f[^L[o^\ǂ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_DTQID_TO_DTQCB_RAM(dtqid) != NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* ɓo^ς */
	}
#endif

	/* f[^L[̐ */
	ercd = kernel_cre_dtq(dtqid, pk_cdtq);
	
	mknl_unl_sys();	/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
