/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l f[^L[                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"
#include "knl_mem.h"



/* f[^L[̍폜 */
ER del_dtq(
		ID dtqid)	/* 폜Ώۂ̃f[^L[IDԍ */
{
	const T_KERNEL_DTQCB_ROM *dtqcb_rom;
	T_KERNEL_DTQCB_RAM *dtqcb_ram;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();		/* VXẽbN */

	dtqcb_ram = KERNEL_DTQID_TO_DTQCB_RAM(dtqid);
	dtqcb_rom = dtqcb_ram->dtqcb_rom;

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( dtqcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	/* ^XN̉ */
	mknl_clr_que(&dtqcb_ram->sndque);	/* M҂^XN̉ */
	mknl_clr_que(&dtqcb_ram->rcvque);	/* M҂^XN̉ */
	
	/* ̉ */
	kernel_fre_mem(dtqcb_ram);
	KERNEL_DTQID_TO_DTQCB_RAM(dtqid) = NULL;
	
	mknl_exe_dsp();		/* ^XNfBXpb`̎s */
	mknl_exe_tex();		/* O̎s */
	
	mknl_unl_sys();		/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
