/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l f[^L[                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"



/* f[^L[ւ̋M */
ER fsnd_dtq(
		ID     dtqid,	/* MΏۂ̃f[^L[IDԍ */
		VP_INT data)	/* f[^L[֑Mf[^ */
{
	const T_KERNEL_DTQCB_ROM *dtqcb_rom;
	T_KERNEL_DTQCB_RAM       *dtqcb_ram;
	T_MKNL_TCB *mtcb;
	UINT tail;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	dtqcb_ram = KERNEL_DTQID_TO_DTQCB_RAM(dtqid);

	/* IuWFNg̑݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( dtqcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	if ( mknl_ref_qhd(&dtqcb_ram->rcvque) != NULL )
	{
		/* M҂^XNΊJ */
		mtcb = mknl_ref_qhd(&dtqcb_ram->rcvque);	/* ҂s擪^XNo */
		mknl_rmv_que(mtcb);							/* ҂s񂩂폜 */
		mknl_rmv_tmout(mtcb);						/* ^CAEg */
		mtcb->data = data;							/* f[^i[ */
		mknl_wup_tsk(mtcb, E_OK);					/* ^XN̑҂ */
		
		mknl_exe_dsp();		/* ^XNfBXpb`̎s */
		mknl_exe_tex();		/* O̎s */
	}
	else
	{
		/* ҂^XN΃f[^L[Ɋi[ */
		dtqcb_rom = dtqcb_ram->dtqcb_rom;
		if ( dtqcb_ram->datacnt >= dtqcb_rom->dtqcnt )
		{
			/* f[^L[TCYmF */
#ifdef HOS_ERCHK_E_ILUSE
			if ( dtqcb_rom->dtqcnt == 0 )
			{
				mknl_unl_sys();	/* VXẽbN */
				return E_ILUSE;	/* T[rXR[sgp */
			}
#endif

			/* L[擪̃f[^𖕏đM */
			dtqcb_rom->dtq[dtqcb_ram->head] = data;
			dtqcb_ram->head++;
			if ( dtqcb_ram->head >= dtqcb_rom->dtqcnt )
			{
				dtqcb_ram->head -= dtqcb_rom->dtqcnt;
			}
		}
		else
		{
			/* f[^L[Ƀf[^i[ */
			tail = dtqcb_ram->head + dtqcb_ram->datacnt;
			if ( tail >= dtqcb_rom->dtqcnt )
			{
				tail -= dtqcb_rom->dtqcnt;
			}
			dtqcb_rom->dtq[tail] = data;
			dtqcb_ram->datacnt++;
		}
	}

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
