/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l f[^L[                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"
#include "knl_mem.h"




/* f[^L[Rg[ubN(Ip) */
typedef struct t_kernel_dtqcb
{
	T_KERNEL_DTQCB_RAM dtqcb_ram;	/* f[^L[Rg[ubN(RAM) */
	T_KERNEL_DTQCB_ROM dtqcb_rom;	/* f[^L[Rg[ubN(ROM) */
} T_KERNEL_DTQCB;

/* f[^L[Rg[ubN(IAJ[lp) */
typedef struct t_kernel_dtqcb_with_blk
{
	T_KERNEL_DTQCB_RAM dtqcb_ram;	/* f[^L[Rg[ubN(RAM) */
	T_KERNEL_DTQCB_ROM dtqcb_rom;	/* f[^L[Rg[ubN(ROM) */
	VP_INT	blk[1];			/* _~[f[^ubN */
} T_KERNEL_DTQCB_WBLK;



/* f[^L[̐(J[l֐) */
ER kernel_cre_dtq(
		ID           dtqid,		/* Ώۂ̃f[^L[IDԍ */
		const T_CDTQ *pk_cdtq)	/* f[^L[ꂽpPbgւ̃|C^ */
{
	T_KERNEL_DTQCB     *dtqcb;
	T_KERNEL_DTQCB_RAM *dtqcb_ram;
	T_KERNEL_DTQCB_ROM *dtqcb_rom;

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_RSATR
	if ( pk_cdtq->dtqatr & ~(TA_TFIFO | TA_TPRI) )
	{
		return E_RSATR;
	}
#endif

	/* f[^L[p̊m */
	dtqcb = (T_KERNEL_DTQCB *)kernel_alc_mem(
		pk_cdtq->dtq != NULL ?
			sizeof(T_KERNEL_DTQCB) :
			sizeof(T_KERNEL_DTQCB_WBLK) - sizeof(VP_INT)
			+ ( sizeof(VP_INT *) * pk_cdtq->dtqcnt )
		);
	if ( dtqcb == NULL )
	{
		return E_NOMEM;		/* s */
	}
	
	/* f[^L[̐ݒ */
	dtqcb_ram = &dtqcb->dtqcb_ram;
	dtqcb_rom = &dtqcb->dtqcb_rom;
	dtqcb_rom->dtqatr = pk_cdtq->dtqatr;
	dtqcb_rom->dtqcnt = pk_cdtq->dtqcnt;
	dtqcb_rom->dtq =  pk_cdtq->dtq != NULL ?
	    (VP_INT *)pk_cdtq->dtq : ((T_KERNEL_DTQCB_WBLK *)dtqcb)->blk;
	mknl_ini_que(&dtqcb_ram->sndque);
	mknl_ini_que(&dtqcb_ram->rcvque);
	dtqcb_ram->head      = 0;
	dtqcb_ram->datacnt   = 0;
	dtqcb_ram->dtqcb_rom = dtqcb_rom;

	/* Ǘe[u֒ǉ */
	KERNEL_DTQID_TO_DTQCB_RAM(dtqid) = dtqcb_ram;

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
