/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l f[^L[                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"



/* f[^L[̎M */
ER rcv_dtq(
		ID     dtqid,	/* MΏۂ̃f[^L[IDԍ */
		VP_INT *p_data)	/* f[^L[Mf[^ */
{
	const T_KERNEL_DTQCB_ROM *dtqcb_rom;
	T_KERNEL_DTQCB_RAM       *dtqcb_ram;
	T_MKNL_TCB *mtcb;
	ER  ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;	/* IDs */
	}
#endif
	
	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR 
	if ( p_data == NULL )
	{
		return E_PAR;	/* p[^[s */
	}
#endif
	
	mknl_loc_sys();	/* VXẽbN */

	/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_CTX;	/* ReLXgs */
	}
#endif

	dtqcb_ram = KERNEL_DTQID_TO_DTQCB_RAM(dtqid);

	/* IuWFNg̑݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( dtqcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	dtqcb_rom = dtqcb_ram->dtqcb_rom;

	if ( dtqcb_ram->datacnt == 0 )
	{
		/* f[^L[Ȃ */
		if ( mknl_ref_qhd(&dtqcb_ram->sndque) != NULL )
		{
			/* M҂^XNΊJ */
			mtcb = mknl_ref_qhd(&dtqcb_ram->sndque);	/* ҂s擪^XNo */
			mknl_rmv_que(mtcb);							/* ҂s񂩂폜 */
			mknl_rmv_tmout(mtcb);						/* ^CAEg */
			*p_data = mtcb->data;						/* f[^o */
			mknl_wup_tsk(mtcb, E_OK);					/* ^XN̑҂ */
			
			mknl_exe_dsp();		/* ^XNfBXpb`̎s */
			mknl_exe_tex();		/* O̎s */
			
			ercd = E_OK;
		}
		else
		{
			/* M҂^XNΎM҂ɓ */
			mtcb = mknl_get_run_tsk();		/* ݂̃^XN擾 */
			mknl_wai_tsk(mtcb, TTW_RDTQ);	/* ҂Ԃɐݒ */
			mknl_add_que(&dtqcb_ram->rcvque, mtcb, dtqcb_rom->dtqatr);	/* ҂sɒǉ */
			
			ercd = (ER)mknl_exe_dsp();	/* ^XNfBXpb`̎s */
			
			/* Ȃf[^i[ */		
			if ( ercd == E_OK )
			{
				*p_data = mtcb->data;
			}
			
			mknl_exe_tex();		/* O̎s */
		}
	}
	else
	{
		/* f[^L[f[^o */
		*p_data = dtqcb_rom->dtq[dtqcb_ram->head];
		dtqcb_ram->head++;
		if ( dtqcb_ram->head >= dtqcb_rom->dtqcnt )
		{
			dtqcb_ram->head = 0;
		}
		
		/* M҂^XNȂJ */
		mtcb = mknl_ref_qhd(&dtqcb_ram->sndque);
		if ( mtcb!= NULL )
		{
			UINT tail;

			/* f[^L[Ƀf[^i[ */
			tail = dtqcb_ram->head + dtqcb_ram->datacnt - 1;
			if ( tail >= dtqcb_rom->dtqcnt )
			{
				tail -= dtqcb_rom->dtqcnt;
			}
			dtqcb_rom->dtq[tail] = mtcb->data;

			mknl_rmv_que(mtcb);			/* ҂s񂩂폜 */
			mknl_rmv_tmout(mtcb);		/* ^CAEg */
			mknl_wup_tsk(mtcb, E_OK);	/* ^XN̑҂ */
			
			mknl_exe_dsp();		/* ^XNfBXpb`̎s */
			mknl_exe_tex();		/* O̎s */
		}
		else
		{
			dtqcb_ram->datacnt--;
		}
		
		ercd = E_OK;
	}

	mknl_unl_sys();	/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
