/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l f[^L[                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_dtq.h"
#include "knl_sys.h"



/* f[^L[̏ԎQ */
ER ref_dtq(
		ID     dtqid,		/* ԎQƑΏۂ̃f[^L[IDԍ */
		T_RDTQ *pk_rdtq)	/* f[^L[ԂԂpPbgւ̃|C^ */
{
	T_KERNEL_DTQCB_RAM       *dtqcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( dtqid < KERNEL_TMIN_DTQID || dtqid > KERNEL_TMAX_DTQID )
	{
		return E_ID;
	}
#endif

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR 
	if ( pk_rdtq == NULL )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	dtqcb_ram = KERNEL_DTQID_TO_DTQCB_RAM(dtqid);

	/* IuWFNg̑݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( dtqcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	/* f[^L[̑M҂s̐擪̃^XNIDԍ擾 */
	mtcb = mknl_ref_qhd(&dtqcb_ram->sndque);	/* ҂s擪^XNo */
	if ( mtcb == NULL )
	{
		pk_rdtq->stskid = TSK_NONE;		/* ҂^XNȂ */
	}
	else
	{
	/* ^XNID */
		pk_rdtq->stskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* CxgtO̎M҂s̐擪̃^XNIDԍ擾 */
	mtcb = mknl_ref_qhd(&dtqcb_ram->rcvque);	/* ҂s擪^XNo */
	if ( mtcb == NULL )
	{
		pk_rdtq->rtskid = TSK_NONE;		/* ҂^XNȂ */
	}
	else
	{
		/* ^XNID */
		pk_rdtq->rtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* f[^̎擾 */
	pk_rdtq->sdtqcnt = dtqcb_ram->datacnt;

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
