/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l CPUOnhǗ                                     */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_exc.h"



/* CPUOnh̊Jn */
void kernel_sta_exc(void)
{
	/* ^XN(荞݃ReLXgɈڍs) */
	mknl_sta_ind();
}


/* CPUOnh̏I */
void kernel_end_exc(void)
{
	/* ^XNɈڍs */
	mknl_ext_ind();

	/* xfBXpb`s */
	mknl_dly_dsp();
}


/* CPUOnhݏs */
void kernel_exe_exc(
		EXCNO excno)		/* CPUOnhԍ */
{
	T_KERNEL_EXCCB exccb;
	
	if ( excno < KERNEL_TMIN_EXCNO || excno > KERNEL_TMAX_EXCNO )
	{
		return;
	}
	
	exccb = kernel_exccb_tbl[excno];	/* [JɃRs[ */
	
	mknl_unl_sys();		/* d荞݋ */
	
	if ( exccb.exchdr != NULL )
	{
		exccb.exchdr();			/* CPUOnhs */
	}
	
	mknl_loc_sys();		/* d荞݋֎~ */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
