/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l CxgtO                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"



/* CxgtO̐(IDԍt) */
ER_ID acre_flg(
		const T_CFLG *pk_cflg)	/* CxgtOꂽpPbgւ̃|C^ */
{
	ID flgid;
	ER ercd;

	mknl_loc_sys();	/* VXẽbN */

	/* p\IĎ */
	for ( flgid = KERNEL_TMAX_FLGID; flgid >= KERNEL_TMIN_FLGID; flgid-- )
	{
		if ( KERNEL_FLGID_TO_FLGCB_RAM(flgid) == NULL )
		{
			break;
		}
	}
	
	/* IDԍs`FbN */
#ifdef HOS_ERCHK_E_NOID
	if ( flgid < KERNEL_TMIN_FLGID )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOID;	/* IDԍs */
	}
#endif

	/* CxgtO̐ */
	ercd = kernel_cre_flg(flgid, pk_cflg);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* VXẽbN */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* VXẽbN */

	return (ER_ID)flgid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
