/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l CxgtO                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"



/* CxgtO̐ */
ER cre_flg(
		ID           flgid,		/* Ώۂ̃CxgtOIDԍ */
		const T_CFLG *pk_cflg)	/* CxgtOꂽpPbgւ̃|C^ */
{
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* CxgtOo^\ǂ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_FLGID_TO_FLGCB_RAM(flgid) != NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* ɓo^ς */
	}
#endif

	/* CxgtO̐ */
	ercd = kernel_cre_flg(flgid, pk_cflg);
	
	mknl_unl_sys();	/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
