/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l CxgtO                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"
#include "knl_mem.h"



/* CxgtO̍폜 */
ER del_flg(
		ID flgid)	/* 폜Ώۂ̃CxgtOIDԍ */
{
	T_KERNEL_FLGCB_RAM *flgcb_ram;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();		/* VXẽbN */

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	/* ҂^XN̉ */
	mknl_clr_que(&flgcb_ram->que);
	
	/* ̉ */
	kernel_fre_mem(flgcb_ram);
	KERNEL_FLGID_TO_FLGCB_RAM(flgid) = NULL;
	
	mknl_exe_dsp();		/* ^XNfBXpb`̎s */
	mknl_exe_tex();		/* O̎s */
	
	mknl_unl_sys();		/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
