/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l CxgtO                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"
#include "knl_sys.h"



/* CxgtȌԎQ */
ER ref_flg(					
		ID     flgid,		/* ԎQƑΏۂ̃CxgtOIDԍ */
		T_RFLG *pk_rflg)	/* CxgtOԂԂpPbgւ̃|C^ */
{
	T_KERNEL_FLGCB_RAM       *flgcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	/* p[^̃`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( pk_rflg == NULL )
	{
		return E_PAR;	/* p[^G[ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* IuWFNg̑݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	/* CxgtȎ҂s̐擪̃^XNIDԍ擾 */
	mtcb = mknl_ref_qhd(&flgcb_ram->que);	/* ҂s擪^XNo */
	if ( mtcb == NULL )
	{
		pk_rflg->wtskid = TSK_NONE;		/* ҂^XNȂ */
	}
	else
	{
		/* ^XNID */
		pk_rflg->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* tOrbgp^[̎擾 */
	pk_rflg->flgptn = flgcb_ram->flgptn;

	mknl_unl_sys();	/* VXẽbN */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
