/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l CxgtO                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"



/* CxgtÕZbg */
ER set_flg(
		ID     flgid,		/* ZbgΏۂ̃CxgtOIDԍ */
		FLGPTN setptn)		/* Zbgrbgp^[ */
{
	const T_KERNEL_FLGCB_ROM *flgcb_rom;
	T_KERNEL_FLGCB_RAM       *flgcb_ram;
	T_KERNEL_FLGINF          *pk_flginf;
	T_MKNL_TCB *mtcb;
	T_MKNL_TCB *mtcb_next;
	BOOL       wupflg = FALSE;	/* NtO */

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_NOEXS;
	}
#endif

	flgcb_rom = flgcb_ram->flgcb_rom;

	/* tÕZbg */
	flgcb_ram->flgptn = (FLGPTN)(flgcb_ram->flgptn | setptn);

	/* ҂^XN΋N`FbN */
	mtcb = mknl_ref_qhd(&flgcb_ram->que);
	while ( mtcb != NULL )
	{
		mtcb_next = mknl_ref_nxt(&flgcb_ram->que, mtcb);	/* ̑҂^XN擾 */
		
		/* tO`FbN */
		pk_flginf = (T_KERNEL_FLGINF *)mtcb->data;
		if ( kernel_chk_flg(flgcb_ram, pk_flginf) )
		{
			/* N𖞂ĂȂ */
			pk_flginf->waiptn = flgcb_ram->flgptn;	/* ݂̃tOp^[i[ */
			if ( flgcb_rom->flgatr & TA_CLR )
			{
				flgcb_ram->flgptn = 0;				/* NA΃NA */
			}

			/* ҂ */
			mknl_rmv_que(mtcb);			/* ҂s񂩂O */
			mknl_rmv_tmout(mtcb);		/* ^CAEg */
			mknl_wup_tsk(mtcb, E_OK);	/* ҂^XN̋N */
			wupflg = TRUE;
		}
		mtcb = mtcb_next;	/* ̃^XNɐi߂ */
	}

	/* Ns^XNȂfBXpb`s */
	if ( wupflg )
	{
		mknl_exe_dsp();		/* ^XNfBXpb`̎s */
		mknl_exe_tex();		/* O̎s */
	}
	
	mknl_unl_sys();	/* VXẽbN */
	
	return E_OK;	/* I */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
