/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l CxgtO                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"



/* CxgtO҂ */
ER wai_flg(
		ID     flgid,		/* ҂Ώۂ̃CxgtOIDԍ */
		FLGPTN waiptn,		/* ҂rbgp^[ */
		MODE   wfmode,		/* ҂[h */
		FLGPTN *p_flgptn)	/* ҂̃rbgp^[i[AhX */
{
	const T_KERNEL_FLGCB_ROM *flgcb_rom;
	T_KERNEL_FLGCB_RAM       *flgcb_ram;
	T_MKNL_TCB      *mtcb;
	T_KERNEL_FLGINF flginf;
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	/* p[^̃`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( (wfmode != TWF_ANDW && wfmode != TWF_ORW) || waiptn == 0 )
	{
		return E_PAR;	/* p[^G[ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_CTX;	/* ReLXgs */
	}
#endif

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* IuWFNg̑݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	flgcb_rom = flgcb_ram->flgcb_rom;

	/* T[rXR[sgp`FbN */
#ifdef HOS_ERCHK_E_ILUSE
	if ( !(flgcb_rom->flgatr & TA_WMUL) && mknl_ref_qhd(&flgcb_ram->que) != NULL )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_ILUSE;		/* T[rXR[sgp */
	}
#endif

	/* ҂ݒ */
	flginf.waiptn = waiptn;
	flginf.wfmode = wfmode;
	
	/* tO`FbN */
	if ( kernel_chk_flg(flgcb_ram, &flginf) )
	{
		/* ɏ𖞂ĂȂ */
		*p_flgptn = flgcb_ram->flgptn;		/* ̃tOp^[i[ */
		if ( flgcb_rom->flgatr & TA_CLR )
		{
			flgcb_ram->flgptn = 0;		/* NA΃NA */
		}
		ercd = E_OK;
	}
	else
	{
		/* 𖞂ĂȂΑ҂ɓ */
		mtcb       = mknl_get_run_tsk();		/* s^XN擾 */
		mtcb->data = (VP_INT)&flginf;			/* ҂Ԃۑ */
		mknl_wai_tsk(mtcb, TTW_FLG);
		mknl_add_que(&flgcb_ram->que, mtcb, flgcb_rom->flgatr);	/* ҂sɒǉ */
		
		ercd = (ER)mknl_exe_dsp();	/* ^XNfBXpb`s */
		
		/* 𖞂ĉꂽ̂Ȃ */
		if ( ercd == E_OK )
		{
			*p_flgptn = flginf.waiptn;			/* ̃tOp^[i[ */
		}
		
		mknl_exe_tex();		/* O̎s */
	}
	
	mknl_unl_sys();	/* VXẽbN */
	
	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
