/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l bZ[Wobt@                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"



/* bZ[Wobt@̐(IDԍt) */
ER_ID acre_mbf(
		const T_CMBF *pk_cmbf)	/* bZ[Wobt@ꂽpPbgւ̃|C^ */
{
	ID mbfid;
	ER ercd;

	mknl_loc_sys();	/* VXẽbN */

	/* p\IĎ */
	for ( mbfid = KERNEL_TMAX_MBFID; mbfid >= KERNEL_TMIN_MBFID; mbfid-- )
	{
		if ( KERNEL_MBFID_TO_MBFCB_RAM(mbfid) == NULL )
		{
			break;
		}
	}
	
	/* IDԍs`FbN */
#ifdef HOS_ERCHK_E_NOID
	if ( mbfid < KERNEL_TMIN_MBFID )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOID;	/* IDԍs */
	}
#endif

	/* bZ[Wobt@̐ */
	ercd = kernel_cre_mbf(mbfid, pk_cmbf);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* VXẽbN */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* VXẽbN */

	return (ER_ID)mbfid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
