/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l bZ[Wobt@                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"



/* bZ[Wobt@̐ */
ER cre_mbf(
		ID           mbfid,		/* Ώۂ̃bZ[Wobt@IDԍ */
		const T_CMBF *pk_cmbf)	/* bZ[Wobt@ꂽpPbgւ̃|C^ */
{
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* bZ[Wobt@o^\ǂ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_MBFID_TO_MBFCB_RAM(mbfid) != NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* ɓo^ς */
	}
#endif

	/* bZ[Wobt@̐ */
	ercd = kernel_cre_mbf(mbfid, pk_cmbf);
	
	mknl_unl_sys();	/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
