/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l bZ[Wobt@                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"
#include "knl_mem.h"


/* bZ[Wobt@̍폜 */
ER del_mbf(
		ID mbfid)	/* 폜Ώۂ̃bZ[Wobt@IDԍ */
{
	T_KERNEL_MBFCB_RAM *mbfcb_ram;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	mbfcb_ram = KERNEL_MBFID_TO_MBFCB_RAM(mbfid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbfcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	/* ҂^XN̉ */
	mknl_clr_que(&mbfcb_ram->sndque);
	mknl_clr_que(&mbfcb_ram->rcvque);
	
	/* ̉ */
	kernel_fre_mem(mbfcb_ram);
	KERNEL_MBFID_TO_MBFCB_RAM(mbfid) = NULL;
	
	mknl_exe_dsp();		/* ^XNfBXpb`̎s */
	mknl_exe_tex();		/* O̎s */
	
	mknl_unl_sys();	/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
