/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l bZ[Wobt@                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"
#include "knl_mem.h"


/* bZ[Wobt@Rg[ubN(Ip) */
typedef struct t_kernel_mbfcb
{
	T_KERNEL_MBFCB_RAM mbfcb_ram;	/* bZ[Wobt@Rg[ubN(RAM) */
	T_KERNEL_MBFCB_ROM mbfcb_rom;	/* bZ[Wobt@Rg[ubN(ROM) */
} T_KERNEL_MBFCB;



/* bZ[Wobt@̐(J[l֐) */
ER kernel_cre_mbf(
		ID           mbfid,		/* Ώۂ̃bZ[Wobt@IDԍ */
		const T_CMBF *pk_cmbf)	/* bZ[Wobt@ꂽpPbgւ̃|C^ */
{
	T_KERNEL_MBFCB     *mbfcb;
	T_KERNEL_MBFCB_RAM *mbfcb_ram;
	T_KERNEL_MBFCB_ROM *mbfcb_rom;

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_RSATR
	if ( pk_cmbf->mbfatr & ~(TA_TFIFO | TA_TPRI) )
	{
		return E_RSATR;
	}
#endif

	/* bZ[Wobt@p̊m */
	mbfcb = (T_KERNEL_MBFCB *)kernel_alc_mem(sizeof(T_KERNEL_MBFCB));
	if ( mbfcb == NULL )
	{
		return E_NOMEM;		/* s */
	}

	/* bZ[Wobt@̐ݒ */
	mbfcb_ram = &mbfcb->mbfcb_ram;
	mbfcb_rom = &mbfcb->mbfcb_rom;
	mknl_ini_que(&mbfcb_ram->sndque);
	mknl_ini_que(&mbfcb_ram->rcvque);
	mbfcb_ram->head      = 0;
	mbfcb_ram->fmbfsz    = pk_cmbf->mbfsz;
	mbfcb_ram->smsgcnt   = 0;
	mbfcb_ram->mbfcb_rom = mbfcb_rom;
	mbfcb_rom->mbfatr    = pk_cmbf->mbfatr;
	mbfcb_rom->maxmsz    = pk_cmbf->maxmsz;
	mbfcb_rom->mbfsz     = pk_cmbf->mbfsz;
	mbfcb_rom->mbf       = pk_cmbf->mbf;

	/* Ǘe[u֒ǉ */
	KERNEL_MBFID_TO_MBFCB_RAM(mbfid) = mbfcb_ram;

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
