/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ bZ[Wobt@                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"
#include "hoslib.h"


static UB kernel_rch_mbf(const T_KERNEL_MBFCB_ROM *mbfcb_rom,
								T_KERNEL_MBFCB_RAM *mbfcb_ram);	/* PLN^M */



/* bZ[Wobt@̎M(J[l֐) */
ER_UINT kernel_rcv_mbf(
		const T_KERNEL_MBFCB_ROM *mbfcb_rom,	/* bZ[Wobt@Rg[ubN(ROM) */
		T_KERNEL_MBFCB_RAM       *mbfcb_ram,	/* bZ[Wobt@Rg[ubN(RAM) */
		VP                       msg)			/* MbZ[Wi[擪Ԓn */
{
	T_MKNL_TCB *mtcb;
	UINT       msgsz;
	UINT       tmpsz;
	INT        i;

	/* bZ[W݃`FbN */
	if ( mbfcb_ram->smsgcnt == 0 )	/* bZ[Wꍇ */
	{
		/* M҂^XN`FbN */
		mtcb = mknl_ref_qhd(&mbfcb_ram->sndque);	/* M҂s̐擪^XNQ */
		if ( mtcb != NULL )
		{
			T_KERNEL_MBFDAT *mbfdat;
			
			/* Mf[^󂯎 */
			mbfdat = (T_KERNEL_MBFDAT *)mtcb->data;
			__hos_bcopy(msg, mbfdat->msg, mbfdat->msgsz);	/* f[^Rs[ */

			/* M^XN̑҂ */
			mknl_rmv_que(mtcb);				/* ҂s񂩂폜 */
			mknl_rmv_tmout(mtcb);			/* ^CAEg҂s񂩂폜 */
			mknl_wup_tsk(mtcb, E_OK);		/* ^XN̑҂ */

			return (ER_UINT)mbfdat->msgsz;	/* 튮 */
		}

		return E_TMOUT;		/* ^CAEg */
	}
	
	/* TCYM */
	msgsz = 0;
	for ( i = 0; i < sizeof(UINT); i++ )
	{
		/* ʂ珇8bitǂݏo */
		msgsz <<= 8;
		msgsz += kernel_rch_mbf(mbfcb_rom, mbfcb_ram);
	}
	
	/* f[^M */
	tmpsz = (UINT)mbfcb_rom->mbfsz - mbfcb_ram->head;	/* ܂Ԃ_܂ł̃TCYZo */
	if ( tmpsz >= msgsz )	/* ܂Ԃ */
	{
		__hos_bcopy(msg, (UB *)mbfcb_rom->mbf + mbfcb_ram->head, msgsz);		/* f[^Rs[ */
	}
	else
	{
		__hos_bcopy(msg, (UB *)mbfcb_rom->mbf + mbfcb_ram->head, tmpsz);		/* ܂Ԃ_܂ŃRs[ */
		__hos_bcopy((UB *)msg + tmpsz, (UB *)mbfcb_rom->mbf, msgsz - tmpsz);	/* c擪Rs[ */
	}

	/* |C^XV */
	mbfcb_ram->head += msgsz;
	if ( mbfcb_ram->head >= mbfcb_rom->mbfsz )
	{
		mbfcb_ram->head -= (UINT)mbfcb_rom->mbfsz;
	}

	/* obt@󂫃TCYXV */
	mbfcb_ram->fmbfsz += msgsz;

	/* MfNg */
	mbfcb_ram->smsgcnt--;

	return (ER_UINT)msgsz;	/* MTCYԂ */
}


/* PLN^M */
UB kernel_rch_mbf(
		const T_KERNEL_MBFCB_ROM *mbfcb_rom,	/* bZ[Wobt@Rg[ubN(ROM) */
		T_KERNEL_MBFCB_RAM       *mbfcb_ram)	/* bZ[Wobt@Rg[ubN(RAM) */
{
	UB chr;

	/* PLN^M */
	chr = *((UB *)mbfcb_rom->mbf + mbfcb_ram->head);

	/* |C^XV */
	if ( mbfcb_ram->head + 1 < (UINT)mbfcb_rom->mbfsz )
	{
		mbfcb_ram->head++;
	}
	else
	{
		mbfcb_ram->head = 0;
	}

	/* obt@󂫃TCYXV */
	mbfcb_ram->fmbfsz++;
	
	return chr;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
