/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ bZ[Wobt@                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"
#include "hoslib.h"


static void kernel_sch_mbf(const T_KERNEL_MBFCB_ROM *mbfcb_rom,
						T_KERNEL_MBFCB_RAM *mbfcb_ram, UB chr);	/* PLN^M */



/* bZ[Wobt@ւ̑M */
ER kernel_snd_mbf(
		const T_KERNEL_MBFCB_ROM *mbfcb_rom,	/* bZ[Wobt@Rg[ubN(ROM) */
		T_KERNEL_MBFCB_RAM       *mbfcb_ram,	/* bZ[Wobt@Rg[ubN(RAM) */
		VP                       msg,			/* MbZ[W̐擪Ԓn */
		UINT                     msgsz)			/* MbZ[W̃TCY(oCg) */
{
	T_MKNL_TCB *mtcb;
	SIZE       fresz;
	SIZE       tail;
	INT        i;

	/* M҂^XN`FbN */
	mtcb = mknl_ref_qhd(&mbfcb_ram->sndque);	/* M҂s̐擪^XNQ */
	if ( mtcb != NULL )
	{
		return E_TMOUT;		/* M҂ɂ΃^CAEg */
	}

	/* M҂^XN`FbN */
	mtcb = mknl_ref_qhd(&mbfcb_ram->rcvque);	/* M҂s̐擪^XNQ */
	if ( mtcb != NULL )
	{
		/* M^XN̑҂ */
		__hos_bcopy((VP)mtcb->data, msg, msgsz);		/* f[^Rs[ */
		mknl_rmv_que(mtcb);						/* ҂s񂩂폜 */
		mknl_rmv_tmout(mtcb);					/* ^CAEg҂s񂩂폜 */
		mknl_wup_tsk(mtcb, (ER_UINT)msgsz);		/* ^XN̑҂ */

		return E_OK;	/* 튮 */
	}

	/* 󂫃TCY`FbN */
	if ( mbfcb_ram->fmbfsz < msgsz + sizeof(UINT) )
	{
		return E_TMOUT;		/* ^CAEg */
	}
	
	/* TCYM */
	for ( i = sizeof(UINT) - 1; i >= 0; i-- )
	{
		/* ʂ珇8bitPʂŏ */
		kernel_sch_mbf(mbfcb_rom, mbfcb_ram, (UB)((msgsz >> (i * 8)) & 0xff));
	}

	/* ʒuZo */
	tail = mbfcb_ram->head - mbfcb_ram->fmbfsz;
	if ( mbfcb_ram->head < mbfcb_ram->fmbfsz )
	{
		tail += mbfcb_rom->mbfsz;
	}

	/* f[^M */
	fresz = (UINT)mbfcb_rom->mbfsz - tail;	/* obt@܂Ԃ܂ł̋󂫃TCYZo */
	if ( fresz >= msgsz )					/* ܂Ԃsv */
	{
		__hos_bcopy((UB *)mbfcb_rom->mbf + tail, msg, msgsz);				/* f[^Rs[ */
	}
	else
	{
		__hos_bcopy((UB *)mbfcb_rom->mbf + tail, msg, fresz);				/* ܂Ԃ_܂ŃRs[ */
		__hos_bcopy((UB *)mbfcb_rom->mbf, (UB *)msg + fresz, msgsz - fresz);	/* c擪Rs[ */
	}

	/* 󂫃TCYXV */
	mbfcb_ram->fmbfsz -= msgsz;

	/* MCNg */
	mbfcb_ram->smsgcnt++;

	return E_OK;
}


/* PLN^M */
void kernel_sch_mbf(
		const T_KERNEL_MBFCB_ROM *mbfcb_rom,	/* bZ[Wobt@Rg[ubN(ROM) */
		T_KERNEL_MBFCB_RAM       *mbfcb_ram,	/* bZ[Wobt@Rg[ubN(RAM) */
		UB                       chr)			/* MLN^ */
{
	SIZE tail;

	/* ʒuZo */
	tail = mbfcb_ram->head - mbfcb_ram->fmbfsz;
	if ( mbfcb_ram->head < mbfcb_ram->fmbfsz )
	{
		tail += mbfcb_rom->mbfsz;
	}

	/* PLN^M */
	*((UB *)mbfcb_rom->mbf + tail) = chr;

	/* obt@󂫃TCYXV */
	mbfcb_ram->fmbfsz--;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
