/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ bZ[Wobt@                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"



/* bZ[Wobt@̎M(|[O) */
ER_UINT prcv_mbf(
		ID   mbfid,		/* MΏۂ̃bZ[Wobt@IDԍ */
		VP   msg)		/* MbZ[Wi[擪Ԓn */
{
	const T_KERNEL_MBFCB_ROM *mbfcb_rom;
	T_KERNEL_MBFCB_RAM       *mbfcb_ram;
	ER_UINT                  ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* IDs */
	}
#endif

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( msg == NULL )
	{
		return E_PAR;	/* p[^[s */		
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	mbfcb_ram = KERNEL_MBFID_TO_MBFCB_RAM(mbfid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbfcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	mbfcb_rom = mbfcb_ram->mbfcb_rom;

	/* obt@M */
	ercd = kernel_rcv_mbf(mbfcb_rom, mbfcb_ram, msg);
	
	mknl_unl_sys();		/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
