/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ bZ[Wobt@                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"
#include "knl_sys.h"


/* bZ[Wobt@̏ԎQ */
ER ref_mbf(
		ID     mbfid,		/* Ԏ擾Ώۂ̃bZ[Wobt@IDԍ */
		T_RMBF *pk_rmbf)	/* bZ[Wobt@ԂԂpPbgւ̃|C^ */
{
	T_KERNEL_MBFCB_RAM *mbfcb_ram;
	T_MKNL_TCB         *mtcb;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* IDs */
	}
#endif

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR 
	if ( pk_rmbf == NULL )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	mbfcb_ram = KERNEL_MBFID_TO_MBFCB_RAM(mbfid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbfcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	/* bZ[Wobt@̑M҂s̐擪̃^XNIDԍ擾 */
	mtcb = mknl_ref_qhd(&mbfcb_ram->sndque);	/* ҂s擪^XNo */
	if ( mtcb == NULL )
	{
		pk_rmbf->stskid = TSK_NONE;		/* ҂^XNȂ */
	}
	else
	{
		/* ^XNID */
		pk_rmbf->stskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}
	
	/* bZ[Wobt@̎M҂s̐擪̃^XNIDԍ擾 */
	mtcb = mknl_ref_qhd(&mbfcb_ram->rcvque);	/* ҂s擪^XNo */
	if ( mtcb == NULL )
	{
		pk_rmbf->rtskid = TSK_NONE;		/* ҂^XNȂ */
	}
	else
	{
		/* ^XNID */
		pk_rmbf->rtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}
	
	/* bZ[Wobt@ɓĂ郁bZ[W̎擾*/
	pk_rmbf->smsgcnt = mbfcb_ram->smsgcnt;
	
	/* bZ[Wobt@̈̋󂫗̈̃TCY̎擾 */
	pk_rmbf->fmbfsz = mbfcb_ram->fmbfsz;
	if ( pk_rmbf->fmbfsz > sizeof(UINT) )
	{
		pk_rmbf->fmbfsz -= sizeof(UINT);
	}
	else
	{
		pk_rmbf->fmbfsz = 0;
	}

	mknl_unl_sys();		/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
