/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lˑ`wb_ bZ[Wobt@                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"



/* bZ[Wobt@ւ̑M */
ER snd_mbf(
		ID   mbfid,		/* MΏۂ̃bZ[Wobt@IDԍ */
		VP   msg,		/* MbZ[W̐擪Ԓn */
		UINT msgsz)		/* MbZ[W̃TCY(oCg) */
{
	const T_KERNEL_MBFCB_ROM *mbfcb_rom;
	T_KERNEL_MBFCB_RAM       *mbfcb_ram;
	T_MKNL_TCB               *mtcb;
	T_KERNEL_MBFDAT          mbfdat;
	ER                       ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* IDs */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_CTX;	/* ReLXgs */
	}
#endif

	mbfcb_ram = KERNEL_MBFID_TO_MBFCB_RAM(mbfid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbfcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	mbfcb_rom = mbfcb_ram->mbfcb_rom;

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( msg == NULL || msgsz > mbfcb_rom->maxmsz )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_PAR;	/* p[^[s */		
	}
#endif

	/* M */
	ercd = kernel_snd_mbf(mbfcb_rom, mbfcb_ram, msg, msgsz);
	if ( ercd == E_TMOUT )	/* ^CAEgȂ */
	{
		/* ^XN҂Ԃɂ */
		mtcb = mknl_get_run_tsk();
		mbfdat.msg   = msg;
		mbfdat.msgsz = msgsz;
		mtcb->data   = (VP_INT)&mbfdat;
		mknl_wai_tsk(mtcb, TTW_SMBF);
		mknl_add_que(&mbfcb_ram->sndque, mtcb, mbfcb_rom->mbfatr);	/* ҂sɒǉ */

		ercd = (ER)mknl_exe_dsp();	/* ^XNfBXpb`̎s */
		mknl_exe_tex();				/* O̎s */
	}
	
	mknl_unl_sys();		/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
