/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l [{bNX                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbx.h"



/* [{bNX̐(IDԍt) */
ER_ID acre_mbx(
		const T_CMBX *pk_cmbx)	/* [{bNXꂽpPbgւ̃|C^ */
{
	ID mbxid;
	ER ercd;

	mknl_loc_sys();	/* VXẽbN */

	/* p\IĎ */
	for ( mbxid = KERNEL_TMAX_MBXID; mbxid >= KERNEL_TMIN_MBXID; mbxid-- )
	{
		if ( KERNEL_MBXID_TO_MBXCB_RAM(mbxid) == NULL )
		{
			break;
		}
	}
	
	/* IDԍs`FbN */
#ifdef HOS_ERCHK_E_NOID
	if ( mbxid < KERNEL_TMIN_MBXID )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOID;	/* IDԍs */
	}
#endif

	/* [{bNX̐ */
	ercd = kernel_cre_mbx(mbxid, pk_cmbx);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* VXẽbN */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* VXẽbN */

	return (ER_ID)mbxid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
