/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l [{bNX                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbx.h"
#include "knl_mem.h"



/* [{bNX̍폜 */
ER del_mbx(
		ID mbxid)	/* 폜Ώۂ̃[{bNXIDԍ */
{
	T_KERNEL_MBXCB_RAM *mbxcb_ram;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mbxid < KERNEL_TMIN_MBXID || mbxid > KERNEL_TMAX_MBXID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	mbxcb_ram = KERNEL_MBXID_TO_MBXCB_RAM(mbxid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbxcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	/* ҂^XN̉ */
	mknl_clr_que(&mbxcb_ram->que);
	
	/* ̉ */
	kernel_fre_mem(mbxcb_ram->mbxcb_rom->mprihd);
	kernel_fre_mem(mbxcb_ram);
	KERNEL_MBXID_TO_MBXCB_RAM(mbxid) = NULL;
	
	mknl_exe_dsp();		/* ^XNfBXpb`̎s */
	mknl_exe_tex();		/* O̎s */
	
	mknl_unl_sys();	/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
