/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l [{bNX                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbx.h"
#include "knl_mem.h"



/* [{bNXRg[ubN(Ip) */
typedef struct t_kernel_mbxcb
{
	T_KERNEL_MBXCB_RAM mbxcb_ram;	/* [{bNXRg[ubN(RAM) */
	T_KERNEL_MBXCB_ROM mbxcb_rom;	/* [{bNXRg[ubN(ROM) */
} T_KERNEL_MBXCB;

/* DxʃL[wb_J[lŊmۂꍇ */
typedef struct t_kernel_mbxcb_ph
{
	T_KERNEL_MBXCB	mbxcb;
	T_MSG		*mprihd[1];
} T_KERNEL_MBXCB_PH;


/* [{bNX̐(J[l֐) */
ER kernel_cre_mbx(
		ID           mbxid,		/* Ώۂ̃[{bNXIDԍ */
		const T_CMBX *pk_cmbx)	/* [{bNXꂽpPbgւ̃|C^ */
{
	T_KERNEL_MBXCB     *mbxcb;
	T_KERNEL_MBXCB_RAM *mbxcb_ram;
	T_KERNEL_MBXCB_ROM *mbxcb_rom;
	T_MSG **mprihd;
	PRI   maxmpri;
	PRI   msgpri;

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_RSATR
	if ( pk_cmbx->mbxatr & ~(TA_TFIFO | TA_TPRI | TA_MFIFO | TA_MPRI) )
	{
		return E_RSATR;
	}
#endif

	/* bZ[WDxt */
	if ( pk_cmbx->mbxatr & TA_MPRI )
	{
		maxmpri = pk_cmbx->maxmpri;
		mprihd  = (T_MSG **)pk_cmbx->mprihd;
	}
	else
	{
		maxmpri = TMIN_MPRI;
		mprihd  = NULL;
	}

	/* [{bNXp̊m */
	mbxcb = (T_KERNEL_MBXCB *)kernel_alc_mem(
			mprihd == NULL ?
			sizeof(T_KERNEL_MBXCB_PH)+TSZ_MPRIHD(maxmpri-1) :
			sizeof(T_KERNEL_MBXCB));
	if ( mbxcb == NULL )
	{
		return E_NOMEM;		/* s */
	}

	/* bZ[WL[wb_J[lŊmۂꍇ̃|C^Zbg */
	if ( mprihd == NULL )
	{
		mprihd = ((T_KERNEL_MBXCB_PH *)mbxcb)->mprihd;
	}

	/* [{bNX̐ݒ */
	mbxcb_ram = &mbxcb->mbxcb_ram;
	mbxcb_rom = &mbxcb->mbxcb_rom;
	mknl_ini_que(&mbxcb_ram->que);
	mbxcb_ram->mbxcb_rom = mbxcb_rom;
	mbxcb_rom->mbxatr    = pk_cmbx->mbxatr;
	mbxcb_rom->maxmpri   = maxmpri;
	mbxcb_rom->mprihd    = mprihd;

	/* Dxʂ̃bZ[WL[̏ */
	for ( msgpri = 0; msgpri <= maxmpri - TMIN_MPRI; msgpri++ )
	{
		mprihd[msgpri] = NULL;
	}

	/* Ǘe[u֒ǉ */
	KERNEL_MBXID_TO_MBXCB_RAM(mbxid) = mbxcb_ram;

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
