/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l [{bNX                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbx.h"
#include "knl_sys.h"



/* [{bNX̏ԎQ */
ER ref_mbx(
		ID     mbxid,		/* ԎQƑΏۂ̃[{bNXIDԍ */
		T_RMBX *pk_rmbx)	/* [{bNXԂԂpPbgւ̃|C^ */
{
	const T_KERNEL_MBXCB_ROM *mbxcb_rom;
	T_KERNEL_MBXCB_RAM       *mbxcb_ram;
	T_MKNL_TCB *mtcb;
	PRI        msgpri;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mbxid < KERNEL_TMIN_MBXID || mbxid > KERNEL_TMAX_MBXID )
	{
		return E_ID;
	}
#endif

	/* p[^̃`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( pk_rmbx == NULL )
	{
		return E_PAR;	/* p[^G[ */
	}
#endif
	
	mknl_loc_sys();	/* VXẽbN */

	mbxcb_ram = KERNEL_MBXID_TO_MBXCB_RAM(mbxid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbxcb_ram == NULL )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_NOEXS;
	}
#endif

	mbxcb_rom = mbxcb_ram->mbxcb_rom;

	/* [{bNX̑҂s̐擪̃^XNIDԍ擾 */
	mtcb = mknl_ref_qhd(&mbxcb_ram->que);	/* ҂s擪^XNo */
	if ( mtcb == NULL )
	{
		pk_rmbx->wtskid = TSK_NONE;		/* ҂^XNȂ */
	}
	else
	{
		/* ^XNID */
		pk_rmbx->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* bZ[WDxɌ */
	for ( msgpri = 0; msgpri <= mbxcb_rom->maxmpri - TMIN_MPRI; msgpri++ )
	{
		if ( mbxcb_rom->mprihd[msgpri] != NULL )
		{
			break;
		}
	}

	if ( msgpri <= mbxcb_rom->maxmpri - TMIN_MPRI )
	{
		/* [{bNXɃf[^Ύo */
		pk_rmbx->pk_msg = mbxcb_rom->mprihd[msgpri];
	}
	else
	{
		/* [{bNXȂ */
		pk_rmbx->pk_msg = NULL;
	}

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
