/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l [{bNX                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbx.h"



/* [{bNXւ̑M */
ER snd_mbx(
		ID    mbxid,		/* MΏۂ̃[{bNXIDԍ */
		T_MSG *pk_msg)		/* [{bNX֑M郁bZ[WpPbg̐擪Ԓn */
{
	const T_KERNEL_MBXCB_ROM *mbxcb_rom;
	T_KERNEL_MBXCB_RAM       *mbxcb_ram;
	T_MKNL_TCB *mtcb;
	T_MSG      *msg;
	PRI        msgpri;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mbxid < KERNEL_TMIN_MBXID || mbxid > KERNEL_TMAX_MBXID )
	{
		return E_ID;
	}
#endif
	
	mknl_loc_sys();	/* VXẽbN */

	mbxcb_ram = KERNEL_MBXID_TO_MBXCB_RAM(mbxid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbxcb_ram == NULL )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_NOEXS;
	}
#endif

	mbxcb_rom = mbxcb_ram->mbxcb_rom;

	/* bZ[WDx擾 */
	if ( mbxcb_rom->mbxatr & TA_MPRI )	/* DxȂ */
	{
		msgpri = (PRI)(((T_MSG_PRI*)pk_msg)->msgpri - TMIN_MPRI);

		/* Dx`FbN */
#ifdef HOS_ERCHK_E_PAR
		if ( msgpri < 0	|| msgpri > mbxcb_rom->maxmpri - TMIN_MPRI )
		{
			mknl_unl_sys();		/* VXẽbN */
			return E_PAR;
		}
#endif
	}
	else	/* DxȂ(FIFO)Ȃ */
	{
		msgpri = 0;
	}

	mtcb = mknl_ref_qhd(&mbxcb_ram->que);		/* ҂s擪^XN擾 */
	if ( mtcb != NULL )
	{
		/* ҂^XNΊJ */
		mtcb->data = (VP_INT)pk_msg;			/* bZ[Wn */
		mknl_rmv_que(mtcb);						/* [{bNX̑҂s񂩂폜 */
		mknl_rmv_tmout(mtcb);					/* ^CAEg҂s񂩂폜 */
		mknl_wup_tsk(mtcb, E_OK);				/* ^XN̑҂ */
		
		mknl_exe_dsp();		/* ^XNfBXpb`̎s */
		mknl_exe_tex();		/* O̎s */
	}
	else
	{
		/* ҂^XNȂ΃[{bNXɐڑ */
		if ( mbxcb_rom->mprihd[msgpri] == NULL )
		{
			/* ŏ̂P̓o^ */
			mbxcb_rom->mprihd[msgpri] = pk_msg;
			pk_msg->next              = pk_msg;
		}
		else
		{
			/* ɒǉ */
			msg                       = mbxcb_rom->mprihd[msgpri];
			pk_msg->next              = msg->next;
			msg->next                 = pk_msg;
			mbxcb_rom->mprihd[msgpri] = pk_msg;
		}
	}

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
