/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lǗ                                                    */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */



#include "knl_mem.h"



/* ̊蓖 */
VP kernel_alc_mem(
		SIZE size)		/* 擾̈̃TCY */
{
	T_KERNEL_MEM_BLK *mblk;
	T_KERNEL_MEM_BLK *mblk_next;
	
	/* q[v̑݃`FbN */
	if ( kernel_mem_base == NULL )
	{
		return NULL;
	}
	
	/* TCỸACg𒲐 */
	size = (size + MEMBLK_ALIGN - 1) & ~(MEMBLK_ALIGN - 1);
	
	/* 󂫗̈ */
	mblk = kernel_mem_base;
	while ( mblk->size != 0 )
	{
		if ( mblk->flag == MEMBLK_FREE && mblk->size >= size )
		{
			/* \ȗeʂ */
			if ( mblk->size - size > MEMBLKSIZE + MEMBLK_ALIGN )
			{
				/* ubN𕪊 */
				mblk_next = (T_KERNEL_MEM_BLK *)((UB *)mblk + MEMBLKSIZE + size);
				mblk_next->prev = mblk;
				mblk_next->size = mblk->size - size - MEMBLKSIZE;
				mblk_next->flag = MEMBLK_FREE;
				mblk->size      = size;
			}
			mblk->flag = MEMBLK_USING;
			
			return (VP)((UB *)mblk + MEMBLKSIZE);
		}
		
		/* ̃ubN֐i */
		mblk = (T_KERNEL_MEM_BLK *)((UB *)mblk + mblk->size + MEMBLKSIZE);
	}

	return NULL;	/* 󂫂 */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
