/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lǗ                                                    */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mem.h"



/* ̉ */
void kernel_fre_mem(VP ptr)
{
	T_KERNEL_MEM_BLK *mblk;
	T_KERNEL_MEM_BLK *mblktmp;
	T_KERNEL_MEM_BLK *mblknext;

	/* |C^͈̓`FbN */
	if ( ptr < (VP)kernel_mem_base || ptr >= (VP)((UB*)kernel_mem_base + kernel_mem_size) )
	{
		return;
	}

	/* ubNʒu擾 */
	mblk = (T_KERNEL_MEM_BLK *)((UB *)ptr - MEMBLKSIZE);

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( mblk->flag != MEMBLK_USING )	/* gpŖ */
	{
		return;
	}
#endif

	/* tO𖢎gpɐݒ */
	mblk->flag = MEMBLK_FREE;
	
	/* ̃ubN`FbN */
	mblktmp = (T_KERNEL_MEM_BLK *)((UB *)ptr + mblk->size);
	if ( mblktmp->flag == MEMBLK_FREE )
	{
		/* ̃ubNgpȂ猋 */
		mblknext = (T_KERNEL_MEM_BLK *)((UB *)mblktmp + mblktmp->size + MEMBLKSIZE);
		mblknext->prev = mblk;
		mblk->size += mblktmp->size + MEMBLKSIZE;
	}

	/* ÕubN`FbN */
	if ( mblk->prev != NULL )
	{
		mblktmp = mblk->prev;
		if ( mblktmp->flag == MEMBLK_FREE )
		{
			/* O̖bNgpȂ猋 */
			mblknext = (T_KERNEL_MEM_BLK *)((UB *)mblk + mblk->size + MEMBLKSIZE);
			mblknext->prev = mblktmp;
			mblktmp->size += mblk->size + MEMBLKSIZE;
		}
	}
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
