/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    J[lǗ                                                    */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mem.h"



/* O[oϐ */
T_KERNEL_MEM_BLK *kernel_mem_base = NULL;	/* J[lp擪ubÑAhX */
SIZE             kernel_mem_size;			/* J[lpTCY */


/* Ǘ */
void kernel_ini_mem(
		void *p_base,		/* Ǘ̈̐擪AhX */
		SIZE size)			/* Ǘ̈̃TCY */
{
	T_KERNEL_MEM_BLK *mblklast;
	
	/* TCỸACg𒲐 */
	size &= ~(MEMBLK_ALIGN - 1);
	
	/* TCY`FbN */
	if ( size <= sizeof(T_KERNEL_MEM_BLK) )
	{
		return;
	}
	
	/* ݒۑ */
	kernel_mem_base = (T_KERNEL_MEM_BLK *)p_base;
	kernel_mem_size = size;
	
	/* I[ʒuɔԐlݒ */
	mblklast = (T_KERNEL_MEM_BLK *)((UB *)p_base + size - MEMBLKSIZE);
	
	/* Ŝ󂫗̈ɐݒ */
	kernel_mem_base->prev = NULL;
	kernel_mem_base->size = size - (MEMBLKSIZE * 2);
	kernel_mem_base->flag = MEMBLK_FREE;
	
	/* I[̔Ԑl𗘗pɐݒ */
	mblklast->prev = NULL;
	mblklast->size = 0;
	mblklast->flag = MEMBLK_USING;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
