/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Œ蒷v[                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"



/* Œ蒷v[̐(IDԍt) */
ER_ID acre_mpf(
		const T_CMPF *pk_cmpf)	/* Œ蒷v[ꂽpPbgւ̃|C^ */
{
	ID mpfid;
	ER ercd;

	mknl_loc_sys();	/* VXẽbN */

	/* p\IĎ */
	for ( mpfid = KERNEL_TMAX_MPFID; mpfid >= KERNEL_TMIN_MPFID; mpfid-- )
	{
		if ( KERNEL_MPFID_TO_MPFCB_RAM(mpfid) == NULL )
		{
			break;
		}
	}
	
	/* IDԍs`FbN */
#ifdef HOS_ERCHK_E_NOID
	if ( mpfid < KERNEL_TMIN_MPFID )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOID;	/* IDԍs */
	}
#endif

	/* Œ蒷v[̐ */
	ercd = kernel_cre_mpf(mpfid, pk_cmpf);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* VXẽbN */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* VXẽbN */

	return (ER_ID)mpfid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
