/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Œ蒷v[                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"



/* Œ蒷ubN̊l(|[O) */
ER pget_mpf(
		ID mpfid,		/* ubNlΏۂ̌Œ蒷v[IDԍ */
		VP *p_blk)		/* lubN̐擪Ԓn */
{
	T_KERNEL_MPFCB_RAM *mpfcb_ram;
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* IDs */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	if ( mpfcb_ram->free != NULL )
	{
		/* 󂫃ubNΊ蓖Ă */
		*p_blk          = mpfcb_ram->free;
		mpfcb_ram->free = *(VP *)mpfcb_ram->free;	/* ̋󂫃GAݒ */
		ercd = E_OK;
	}
	else
	{
		/* 󂫃ubN΃^CAEg */
		ercd = E_TMOUT;
	}

	mknl_unl_sys();		/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
