/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Œ蒷v[                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"
#include "knl_sys.h"



/* Œ蒷ubN̏ԎQ */
ER ref_mpf(
		ID     mpfid,		/* Ԏ擾Ώۂ̌Œ蒷v[IDԍ */
		T_RMPF *pk_rmpf)	/* Œ蒷v[ԂԂpPbgւ̃|C^ */
{
	T_KERNEL_MPFCB_RAM *mpfcb_ram;
	T_MKNL_TCB *mtcb;
	VP   blk;
	UINT blkcnt;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* IDs */
	}
#endif

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR 
	if ( pk_rmpf == NULL )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	/* Œ蒷ubN̑҂s̐擪̃^XNIDԍ擾 */
	mtcb = mknl_ref_qhd(&mpfcb_ram->que);	/* ҂s擪^XNo */
	if ( mtcb == NULL )
	{
		pk_rmpf->wtskid = TSK_NONE;		/* ҂^XNȂ */
	}
	else
	{
		/* ^XNID */
		pk_rmpf->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* 󂫃ubÑJEg */
	blkcnt = 0;
	blk    = mpfcb_ram->free;
	while ( blk != NULL )
	{
		blk = *(VP *)blk;
		blkcnt++;
	}

	pk_rmpf->fblkcnt = blkcnt;
	
	mknl_unl_sys();		/* VXẽbN */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
